/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class SystemPrivilege {
    private final String name;

    public SystemPrivilege(String name) {
        this.name = name;
    }

    public boolean exists(JdbcConnection connection) {
        PreparedStatement statement = connection.prepareSQLCommand("SELECT COUNT(*) FROM PUBLIC.PRIVILEGES WHERE TYPE='SYSTEMPRIVILEGE' AND NAME=?");
        try {
            statement.setString(1, this.name);
        }
        catch (SQLException e) {
            throw new HdbException(e);
        }
        List<String> result = connection.executeSQLCommand(statement);
        if (result.size() != 1) {
            throw new HdbException("Unexpected number of result records. Expected 1, but was " + result.size());
        }
        if ("0".equals(result.get(0))) {
            return false;
        }
        if ("1".equals(result.get(0))) {
            return true;
        }
        throw new HdbException(result.get(0) + " system privileges named '" + this.name + "' found.");
    }

    public String getName() {
        return this.name;
    }
}

