/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.instance.Result;
import com.sap.hdb.sl.lib.instance.Sid;
import java.util.Locale;
import java.util.regex.Pattern;

public class TenantSid
extends Sid {
    private final int MIN_LENGTH = 3;
    private final int MAX_LENGTH = 40;

    public TenantSid(String name) {
        super(name, false);
        this.validate(name);
    }

    private Result validate(String nameParam) {
        String name = nameParam.toUpperCase(Locale.ENGLISH).trim();
        if (3 < name.length() && name.length() > 40) {
            return new Result(false, name + " Tenant SID has to be " + 40 + " characters long!");
        }
        for (String s : RESERVED_KEYWORDS) {
            if (!name.equals(s)) continue;
            return new Result(false, name + " Tenant SID is not allowed!");
        }
        if (!Pattern.matches("^[A-Z][A-Z0-9_]{2,39}", name)) {
            return new Result(false, name + " Tenant SID can only contain A-Z as first character and A-Z or 0-9 for the second and third character!");
        }
        this.sid = name;
        return new Result(true, "Sid is fine!");
    }
}

