/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.instance;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.FileParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterNameIF;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlParameters
implements CmdClazzParameter {
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();
    private CmdClazzParameterNameIF cmdClassParameterName;
    private String value;
    private Document document;

    public XmlParameters(String value) {
        this.document = this.loadFromString(value);
    }

    public XmlParameters(File file) {
        this.document = this.loadFromFile(file);
    }

    public XmlParameters(CmdClazzParameterMap parameters) {
        if (parameters.containsKey(CmdClazzParameterName.XML_PARAMETERS)) {
            this.document = this.loadFromString(parameters.get(CmdClazzParameterName.XML_PARAMETERS).getValue());
        } else if (parameters.containsKey(CmdClazzParameterName.XML_PARAMETER_FILE)) {
            FileParameter xmlParameterFile = (FileParameter)parameters.get(CmdClazzParameterName.XML_PARAMETER_FILE);
            this.document = this.loadFromFile(xmlParameterFile.getFile());
        } else {
            throw new HdbException("Either " + CmdClazzParameterName.XML_PARAMETERS + " or " + CmdClazzParameterName.XML_PARAMETER_FILE + " must be provided.");
        }
    }

    private Document loadFromString(String xml) {
        try {
            DocumentBuilder documentBuilder = FACTORY.newDocumentBuilder();
            return documentBuilder.parse(new InputSource(new StringReader(xml)));
        }
        catch (ParserConfigurationException e) {
            throw new HdbException(e);
        }
        catch (SAXException e) {
            throw new HdbException(e);
        }
        catch (IOException e) {
            throw new HdbException(e);
        }
    }

    private Document loadFromFile(File file) {
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            DocumentBuilder documentBuilder = FACTORY.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(reader));
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new HdbException(e);
        }
        catch (SAXException e) {
            throw new HdbException(e);
        }
        catch (IOException e) {
            throw new HdbException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public Document getParameterXmlDocument() {
        return this.document;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public CmdClazzParameterNameIF getCmdClazzParameterName() {
        return this.cmdClassParameterName;
    }

    @Override
    public void setCmdClazzParameterName(CmdClazzParameterNameIF name) {
        this.cmdClassParameterName = name;
    }
}

