/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.logging;

import com.sap.hdb.sl.lib.logging.LogEvent;
import com.sap.hdb.sl.lib.logging.LogWriterFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

class LogFileWriter
implements LogWriterFile {
    private static LogFileWriter INSTANCE = null;
    private PrintWriter writer = null;
    private File logFile = null;

    private LogFileWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public LogFileWriter(PrintWriter writer, File logFile) {
        this(writer);
        this.logFile = logFile;
    }

    public static LogFileWriter getInstance() {
        try {
            String logDir = System.getProperty("java.io.tmpdir");
            String filename = "HDB_SL_Logfile.log";
            File logFile = new File(logDir, filename);
            if (logFile.exists()) {
                logFile.delete();
            }
            logFile.createNewFile();
            INSTANCE = new LogFileWriter(new PrintWriter(logFile), logFile);
        }
        catch (FileNotFoundException e) {
            INSTANCE = new LogFileWriter(new PrintWriter(LogFileWriter.getOutputStreamWriter()));
        }
        catch (IOException e) {
            INSTANCE = new LogFileWriter(new PrintWriter(LogFileWriter.getOutputStreamWriter()));
        }
        catch (Exception e) {
            INSTANCE = new LogFileWriter(new PrintWriter(LogFileWriter.getOutputStreamWriter()));
        }
        return INSTANCE;
    }

    private static OutputStreamWriter getOutputStreamWriter() {
        try {
            return new OutputStreamWriter((OutputStream)System.out, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void append(LogEvent event) {
        this.writer.println(event.getTimestamp().toString() + " | " + event.getClassName() + " | " + event.getMessage());
        this.writer.flush();
    }

    @Override
    public File getLogFile() {
        return this.logFile;
    }
}

