/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.logging;

import com.sap.hdb.sl.lib.logging.LogEventImpl;
import com.sap.hdb.sl.lib.logging.LogFileWriter;
import com.sap.hdb.sl.lib.logging.LogManager;
import com.sap.hdb.sl.lib.logging.LogWriter;
import com.sap.hdb.sl.lib.logging.LogWriterFile;
import com.sap.hdb.sl.lib.user.password.Password;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import java.util.ArrayList;

public class LogManagerImpl
implements LogManager {
    private static LogManagerImpl INSTANCE = null;
    private ArrayList<LogWriter> allLogWriter = new ArrayList();

    public static synchronized LogManagerImpl getInstance() {
        if (null == INSTANCE) {
            INSTANCE = new LogManagerImpl();
            INSTANCE.addLogWriter(LogFileWriter.getInstance());
        }
        return INSTANCE;
    }

    private LogManagerImpl() {
    }

    @Override
    public void addLogWriter(LogWriter logWriterImpl) {
        this.allLogWriter.add(logWriterImpl);
    }

    @Override
    public void removeLogWriter(LogWriter logWriterImpl) {
        this.allLogWriter.remove(logWriterImpl);
    }

    @Override
    public synchronized void writeLogEntry(Class<?> className, String message) {
        this.writeLogEntry(className, message, false);
    }

    @Override
    public synchronized void writeLogEntry(Class<?> className, String message, boolean stdout) {
        message = this.maskPasswordsInString(message);
        if (stdout) {
            System.out.println(message);
        }
        LogEventImpl event = new LogEventImpl(message, className);
        for (LogWriter logWriter : this.allLogWriter) {
            logWriter.append(event);
        }
    }

    private String maskPasswordsInString(String message) {
        ArrayList<Password> passwords = PasswordFactory.getPasswords();
        for (Password password : passwords) {
            String pwd;
            if (password.isValid()) {
                pwd = password.get();
                if (!message.contains(pwd)) continue;
                message = message.replace(pwd, "*");
                continue;
            }
            pwd = password.get();
            String[] words = message.split(" ");
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < words.length; ++i) {
                String word = words[i];
                if (word.equalsIgnoreCase(pwd)) {
                    buffer.append("*");
                } else if (word.equalsIgnoreCase("\"" + pwd + "\"")) {
                    buffer.append("\"*\"");
                } else {
                    buffer.append(word);
                }
                if (i >= words.length - 1) continue;
                buffer.append(" ");
            }
            message = buffer.toString();
        }
        return message;
    }

    @Override
    public ArrayList<LogWriterFile> getLogWriterFile() {
        ArrayList<LogWriterFile> files = new ArrayList<LogWriterFile>();
        for (LogWriter writer : this.allLogWriter) {
            if (!(writer instanceof LogWriterFile)) continue;
            files.add((LogWriterFile)writer);
        }
        return files;
    }
}

