/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.manifest;

import com.sap.hdb.sl.lib.manifest.HdbManifest;
import com.sap.hdb.sl.lib.manifest.HdbSlLibManifest;

public class MainClass {
    private static void writeHelp() {
        System.out.println("usage: java -jar <Classpath e.g.: ./com.sap.hdb.sl.lib.jar> [<options>]");
        System.out.println("\t<options>:");
        System.out.println("\t\t-a Attribute from META-INF/MANIFEST.MF within jar file.");
        System.out.println("\t\t   Example: java -jar ./com.sap.hdb.sl.lib.jar -a API-Version");
        System.out.println("");
        System.out.println("Environment variable HDB_INSTALLATION_PARAMETER [ _INSTALL_CLIENT | _INSTALL_SERVER ]");
        System.out.println("Use this to set additional hdbinst options.");
        System.out.println("In case it is only relevant for client or server installation add _INSTALL_CLIENT or _INSTALL_SERVER to the variable.");
        System.out.println("\tusage:");
        System.out.println("\t\tExample: setenv HDB_INSTALLATION_PARAMETER_INSTALL_SERVER --ignore=check_hardware");
        System.out.println("\t\t         Restart Installation tool");
    }

    public static void main(String[] args) throws Exception {
        MainClass mainClass = new MainClass();
        if (args.length == 0 || args[0].equalsIgnoreCase("-v") || args[0].equalsIgnoreCase("--version")) {
            HdbSlLibManifest hdbManifest = new HdbSlLibManifest();
            mainClass.writeFullVersionToStdout(hdbManifest);
        } else if (args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("--help")) {
            MainClass.writeHelp();
        } else if (args[0].equalsIgnoreCase("-a") && args.length == 2) {
            String attributeName = args[1];
            HdbSlLibManifest hdbManifest = new HdbSlLibManifest();
            mainClass.writeAttributeToStdout(hdbManifest, attributeName);
        } else {
            MainClass.writeHelp();
        }
    }

    public void writeAttributeToStdout(HdbManifest hdbManifest, String attributeName) {
        String value = null;
        if (attributeName.endsWith(":")) {
            attributeName = attributeName.substring(0, attributeName.indexOf(":"));
        }
        value = hdbManifest.doesAttributeExist(attributeName) ? hdbManifest.getAttributeValue(attributeName) : "";
        System.out.println(attributeName + ": " + value);
    }

    public void writeFullVersionToStdout(HdbManifest hdbManifest) {
        HdbSlLibManifest.Attribute[] attributes;
        HdbSlLibManifest.Section slLibSection = HdbSlLibManifest.Section.COM_SAP_HDB_SL_LIB;
        if (hdbManifest.doesHdbSectionExist()) {
            System.out.println("package: " + (Object)((Object)slLibSection));
        } else {
            System.out.println((Object)((Object)slLibSection) + " No such package found in Manifest!");
        }
        for (HdbSlLibManifest.Attribute attribute : attributes = HdbSlLibManifest.Attribute.values()) {
            String attributeName = attribute.toString();
            this.writeAttributeToStdout(hdbManifest, attributeName);
        }
    }
}

