/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.mem;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class HdbsllibMem {
    private static HdbsllibMem INSTANCE = null;
    static String fileName = "./HdbsllibMem.txt";
    static File memFile;
    protected PrintWriter writer = null;
    protected BufferedReader reader = null;
    static String OPEN_BRACKET_KEY;
    static String CLOSE_BRACKET_KEY;
    public static String DESTVERS;
    public static String HDBUSERSTORE;

    public HdbsllibMem(String fileName) {
        this.createFile(fileName);
    }

    public static HdbsllibMem getInstance() {
        if (null == INSTANCE) {
            INSTANCE = new HdbsllibMem(fileName);
        }
        return INSTANCE;
    }

    public static void instantiate(CmdClazzParameterMap parameters) {
        if (parameters.containsKey(CmdClazzParameterName.MEM_FILE_NAME)) {
            CmdClazzParameter parameter = parameters.get(CmdClazzParameterName.MEM_FILE_NAME);
            fileName = parameter.getValue();
            INSTANCE = new HdbsllibMem(fileName);
        }
    }

    private void createFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            try {
                boolean created = file.createNewFile();
                if (!created) {
                    throw new HdbException(memFile + " could not be created!");
                }
            }
            catch (IOException e) {
                throw new HdbException(e.getMessage());
            }
        }
        memFile = file;
    }

    private void createWriter(boolean append) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(memFile, append));
        }
        catch (FileNotFoundException e) {
            throw new HdbException(e.getMessage());
        }
        catch (IOException e) {
            throw new HdbException(e.getMessage());
        }
        this.writer = pw;
    }

    private void createReader() {
        if (!memFile.exists() || !memFile.isFile()) {
            LogFactory.writeLogEntry(this.getClass(), "No memFile file found. Nothing to do.");
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(memFile));
        }
        catch (FileNotFoundException e) {
            throw new HdbException(e.getMessage());
        }
        this.reader = br;
    }

    private void write(String[] lines) {
        this.createWriter(false);
        for (String line : lines) {
            this.writer.println(line);
            this.writer.flush();
        }
    }

    public void save(String code, String line) {
        Map<String, String> memMap = this.readMemFile();
        memMap.put(code, line);
        ArrayList<String> linesList = new ArrayList<String>();
        for (String key : memMap.keySet()) {
            linesList.add(key + memMap.get(key));
        }
        String[] lines = new String[linesList.size()];
        lines = linesList.toArray(lines);
        this.write(lines);
    }

    public void delete(String code) {
        Map<String, String> memMap = this.readMemFile();
        memMap.remove(code);
        ArrayList<String> linesList = new ArrayList<String>();
        for (String key : memMap.keySet()) {
            linesList.add(key + memMap.get(key));
        }
        String[] lines = new String[linesList.size()];
        lines = linesList.toArray(lines);
        this.write(lines);
    }

    public String read(String code) {
        Map<String, String> memMap = this.readMemFile();
        String ret = memMap.get(code);
        if (null != ret) {
            ret.trim();
        }
        return ret;
    }

    private Map<String, String> readMemFile() {
        HashMap<String, String> memMap = new HashMap<String, String>();
        try {
            this.createReader();
            if (null != this.reader) {
                String l;
                while ((l = this.reader.readLine()) != null) {
                    if (!this.isMemLine(l) || this.isCommentedOut(l)) continue;
                    String key = l.substring(l.indexOf(OPEN_BRACKET_KEY), l.indexOf(CLOSE_BRACKET_KEY) + 1);
                    String value = l.substring(l.indexOf(CLOSE_BRACKET_KEY) + 1);
                    memMap.put(key, value);
                }
            } else {
                LogFactory.writeLogEntry(this.getClass(), "No reader for memFile found. Nothing to do.");
            }
        }
        catch (Exception e) {
            throw new HdbException(e.getMessage());
        }
        return memMap;
    }

    private boolean isMemLine(String line) {
        line.trim();
        return line.indexOf(OPEN_BRACKET_KEY) >= 0 && line.indexOf(OPEN_BRACKET_KEY) < line.indexOf(CLOSE_BRACKET_KEY);
    }

    private boolean isCommentedOut(String line) {
        line.trim();
        return line.startsWith("#") || line.startsWith("--");
    }

    static {
        OPEN_BRACKET_KEY = "[";
        CLOSE_BRACKET_KEY = "]";
        DESTVERS = "[destvers]";
        HDBUSERSTORE = "[hdbuserstore]";
    }
}

