/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.memory;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.memory.ResourcesData;
import com.sap.hdb.sl.lib.memory.Size;
import com.sap.hdb.sl.lib.memory.TableData;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MergeMonitor {
    private boolean isDoneInitialSelection = false;
    private ArrayList<ResourcesData> recentResourceDataList = null;
    private ResourcesData currentResourcesData;
    private int cores = 40;
    private int memoryFactor = 1;
    private boolean isScaleOutLandscape = false;
    private boolean hasDoneScaleOutSelect = false;
    private String masterHostName = null;
    private ArrayList<TableData> allTableDataList = new ArrayList();
    private ArrayList<TableData> currentTableDataList = new ArrayList();

    public ArrayList<ResourcesData> getCurrentResourcesDataList(JdbcConnection connection) throws SQLException {
        ArrayList<ResourcesData> currentResourcesDataList = new ArrayList<ResourcesData>();
        int numberOfSelects = 1;
        if (!this.isDoneInitialSelection) {
            numberOfSelects = 2;
        }
        Connection conn = connection.getConnection();
        for (int i = 0; i < numberOfSelects; ++i) {
            ResourcesData currentResourcesData = null;
            PreparedStatement stmt = conn.prepareStatement("SELECT T1.HOST, T1.SYS_TIMESTAMP, T1.TOTAL_CPU_USER_TIME, T1.TOTAL_CPU_SYSTEM_TIME, T1.TOTAL_CPU_WIO_TIME, T1.TOTAL_CPU_IDLE_TIME, T2.EFFECTIVE_ALLOCATION_LIMIT, T2.TOTAL_MEMORY_USED_SIZE\t FROM \"PUBLIC\".\"M_HOST_RESOURCE_UTILIZATION\" T1, \"PUBLIC\".\"M_SERVICE_MEMORY\" T2 WHERE T2.SERVICE_NAME = 'indexserver' AND T1.HOST = T2.HOST");
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String hostName = rs.getString("HOST");
                currentResourcesData = new ResourcesData(hostName);
                currentResourcesData.setScaleOutLandscape(this.isScaleOutLandscape(conn));
                currentResourcesData.setNumberOfSlaveNodes(this.getNumberOfSlaveNodes(conn));
                if (hostName.equalsIgnoreCase(this.getMasterHostName(connection))) {
                    currentResourcesData.setIsMasterHost(true);
                } else {
                    currentResourcesData.setIsMasterHost(false);
                }
                BigInteger totalCpuUserTime = rs.getBigDecimal("TOTAL_CPU_USER_TIME").unscaledValue();
                currentResourcesData.setTotalCpuUserTime(totalCpuUserTime);
                BigInteger totalCpuSystemTime = rs.getBigDecimal("TOTAL_CPU_SYSTEM_TIME").unscaledValue();
                currentResourcesData.setTotalCpuSystemTime(totalCpuSystemTime);
                BigInteger totalCpuWioTime = rs.getBigDecimal("TOTAL_CPU_WIO_TIME").unscaledValue();
                currentResourcesData.setTotalCpuWioTime(totalCpuWioTime);
                BigInteger totalCpuIdleTime = rs.getBigDecimal("TOTAL_CPU_IDLE_TIME").unscaledValue();
                currentResourcesData.setTotalCpuIdleTime(totalCpuIdleTime);
                currentResourcesData.setEndTimeStamp(rs.getTimestamp("SYS_TIMESTAMP"));
                BigInteger effetiveAllocationLimit = rs.getBigDecimal("EFFECTIVE_ALLOCATION_LIMIT").unscaledValue();
                BigInteger usedMemory = rs.getBigDecimal("TOTAL_MEMORY_USED_SIZE").unscaledValue();
                BigInteger freeMemory = effetiveAllocationLimit.subtract(usedMemory);
                currentResourcesData.setEffectiveAllocationLimit(effetiveAllocationLimit);
                currentResourcesData.setUsedMemory(usedMemory);
                currentResourcesData.setFreeMemory(freeMemory);
                currentResourcesData.setMemorySizeInDelta(this.findMemorySizeInDelta(conn));
                if (null != this.recentResourceDataList) {
                    int cpuUsage = this.calculateCPUusage(currentResourcesData, hostName);
                    currentResourcesData.setCpuUsage(cpuUsage);
                    currentResourcesData.setStartTimeStamp(this.recentResourceDataList.get(0).getEndTimeStamp());
                } else {
                    this.isDoneInitialSelection = true;
                }
                this.addHostInformationToResourceData(currentResourcesData, hostName, conn);
                this.currentResourcesData = currentResourcesData;
                currentResourcesDataList.add(currentResourcesData);
            }
            this.recentResourceDataList = currentResourcesDataList;
        }
        return currentResourcesDataList;
    }

    public String getMasterHostName(JdbcConnection connection) throws SQLException {
        if (null == this.masterHostName) {
            String query = "SELECT HOST FROM M_LANDSCAPE_HOST_CONFIGURATION WHERE NAMESERVER_ACTUAL_ROLE IN ('MASTER', 'COORDINATOR')";
            List<String> result = connection.executeSQLCommand(query);
            if (result.size() != 1) {
                throw new HdbException(result.size() + ", expected result size was 1. Error during execution of SQL command: " + query);
            }
            this.masterHostName = result.get(0);
            if (null == this.masterHostName) {
                throw new SQLException(query + " Statement did not return a result! User: " + connection.getConnectUser().getName() + " must have sufficient permission!");
            }
        }
        return this.masterHostName;
    }

    public int getNumberOfSlaveNodes(Connection connection) throws SQLException {
        int numberOfSlaveNodes = 0;
        PreparedStatement stmt = connection.prepareStatement("SELECT COUNT(HOST) FROM M_LANDSCAPE_HOST_CONFIGURATION WHERE NAMESERVER_ACTUAL_ROLE = 'SLAVE'  AND HOST_STATUS = 'OK'");
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            numberOfSlaveNodes = result.getInt(1);
        }
        return numberOfSlaveNodes;
    }

    public boolean isScaleOutLandscape(Connection connection) throws SQLException {
        if (!this.hasDoneScaleOutSelect) {
            int nodeNumber = 0;
            PreparedStatement stmt = connection.prepareStatement("SELECT COUNT(HOST) FROM M_LANDSCAPE_HOST_CONFIGURATION WHERE HOST_STATUS = 'OK'");
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                nodeNumber = result.getInt(1);
            }
            if (nodeNumber > 1) {
                this.isScaleOutLandscape = true;
            }
            this.hasDoneScaleOutSelect = true;
        }
        return this.isScaleOutLandscape;
    }

    private void addHostInformationToResourceData(ResourcesData resourcesData, String hostName, Connection connection) throws SQLException {
        ResultSet rs = null;
        PreparedStatement stmt = connection.prepareStatement("SELECT * FROM \"SYS\".\"M_HOST_INFORMATION\" WHERE HOST = ?");
        stmt.setString(1, hostName);
        rs = stmt.executeQuery();
        HashMap<String, String> hostInfoMap = new HashMap<String, String>();
        while (rs.next()) {
            if (!resourcesData.getHost().equalsIgnoreCase(rs.getString("HOST"))) continue;
            hostInfoMap.put(rs.getString("KEY"), rs.getString("VALUE"));
        }
        resourcesData.setHostInformationMap(hostInfoMap);
    }

    private boolean hasRecentResourceDataForHost(String hostName) {
        boolean hasData = false;
        for (ResourcesData resourceData : this.recentResourceDataList) {
            String currentHostName = resourceData.getHost();
            if (!hostName.equalsIgnoreCase(currentHostName)) continue;
            hasData = true;
            break;
        }
        return hasData;
    }

    private int calculateCPUusage(ResourcesData currentResourcesData, String hostName) {
        ResourcesData recentResourceData = null;
        if (!this.hasRecentResourceDataForHost(hostName)) {
            LogFactory.writeLogEntry(this.getClass(), "No resource data found for host: " + hostName + ". Using 0 for CPU usage!");
            return 0;
        }
        recentResourceData = this.getRecentResourceDataForHost(hostName);
        BigInteger recentTotalCpuUserTime = recentResourceData.getTotalCpuUserTime();
        BigInteger currentTotalCpuUserTime = currentResourcesData.getTotalCpuUserTime();
        BigInteger totalCpuUserTime = currentTotalCpuUserTime.subtract(recentTotalCpuUserTime);
        BigInteger recentTotalCpuSystemTime = recentResourceData.getTotalCpuSystemTime();
        BigInteger currentTotalCpuSystemTime = currentResourcesData.getTotalCpuSystemTime();
        BigInteger totalCpuSystemTime = currentTotalCpuSystemTime.subtract(recentTotalCpuSystemTime);
        BigInteger recentTotalCpuWioTime = recentResourceData.getTotalCpuWioTime();
        BigInteger currentTotalCpuWioTime = currentResourcesData.getTotalCpuWioTime();
        BigInteger totalCpuWioTime = currentTotalCpuWioTime.subtract(recentTotalCpuWioTime);
        BigInteger currentTotalCpuIdleTime = currentResourcesData.getTotalCpuIdleTime();
        BigInteger recentTotalCpuIdleTime = recentResourceData.getTotalCpuIdleTime();
        BigInteger totalCpuIdleTime = currentTotalCpuIdleTime.subtract(recentTotalCpuIdleTime);
        BigInteger bigNumerator = totalCpuUserTime.add(totalCpuSystemTime).add(totalCpuWioTime);
        bigNumerator = bigNumerator.multiply(BigInteger.valueOf(100L));
        BigInteger bigDenominator = totalCpuUserTime.add(totalCpuSystemTime).add(totalCpuWioTime).add(totalCpuIdleTime);
        BigInteger bigIntResult = new BigInteger("0");
        if (bigDenominator.intValue() > 0) {
            bigIntResult = bigNumerator.divide(bigDenominator);
        }
        int result = bigIntResult.intValue();
        return result;
    }

    private ResourcesData getRecentResourceDataForHost(String hostName) {
        ResourcesData recentResourceData = new ResourcesData(hostName);
        ArrayList<String> hostNames = new ArrayList<String>();
        for (ResourcesData resourceData : this.recentResourceDataList) {
            String currentHostName = resourceData.getHost();
            hostNames.add(currentHostName);
            if (!hostName.equalsIgnoreCase(currentHostName)) continue;
            recentResourceData = resourceData;
            break;
        }
        return recentResourceData;
    }

    public BigInteger findMemorySizeInDelta(Connection connection) {
        BigInteger memorySizeInDelta = null;
        try {
            PreparedStatement stmt = connection.prepareStatement("SELECT ROUND(SUM(MEMORY_SIZE_IN_DELTA)) as MEMORY_SIZE_IN_DELTA FROM SYS.M_CS_TABLES where SCHEMA_NAME NOT LIKE '%SYS%'");
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                memorySizeInDelta = rs.getBigDecimal("MEMORY_SIZE_IN_DELTA").unscaledValue();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return memorySizeInDelta;
    }

    public void findTablesInDelta(Connection connection, ResourcesData resourcesData) throws SQLException {
        PreparedStatement stmt = connection.prepareStatement("SELECT SCHEMA_NAME, TABLE_NAME, ROUND(MEMORY_SIZE_IN_DELTA/1024/1024) as MEMORY_SIZE_IN_DELTA_MB, ROUND(MEMORY_SIZE_IN_MAIN/1024/1024) as MEMORY_SIZE_IN_MAIN_MB FROM SYS.M_CS_TABLES where SCHEMA_NAME = CURRENT_USER and MEMORY_SIZE_IN_DELTA/1024/1024 > 2 ORDER BY MEMORY_SIZE_IN_DELTA DESC");
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            String schemaName = rs.getString("SCHEMA_NAME");
            String tableName = rs.getString("TABLE_NAME");
            int deltaSizeMb = rs.getInt("MEMORY_SIZE_IN_DELTA_MB");
            int mainSizeMb = rs.getInt("MEMORY_SIZE_IN_MAIN_MB");
            TableData tableData = new TableData(schemaName, tableName, deltaSizeMb, mainSizeMb);
            this.addTableDataToAll(tableData);
        }
        LogFactory.writeLogEntry(this.getClass(), "Found " + this.getAllTableDataList().size() + " tables with more than 2 MB in delta. Will try to merge these...");
    }

    public int mergeTablesInDelta(Connection connection, int tokens) {
        PreparedStatement mergePrepStmt = null;
        String mergeStatement = null;
        int runningMerges = this.checkForFinishedMerges(connection);
        if ((tokens -= runningMerges) > 0) {
            try {
                for (int i = 0; i < tokens; ++i) {
                    TableData tableData = this.removeTableDataFromAll();
                    if (null == tableData) {
                        return -1;
                    }
                    this.addTableDataToCurrent(tableData);
                    mergeStatement = tableData.getMergeStatement();
                    mergePrepStmt = connection.prepareStatement(mergeStatement);
                    System.out.println(mergeStatement);
                    LogFactory.writeLogEntry(this.getClass(), "Memory size in delta for table " + tableData.tableName + " " + tableData.deltaSizeMb + " MB.");
                    LogFactory.writeLogEntry(this.getClass(), "Run SQL command: " + mergeStatement);
                    mergePrepStmt.execute();
                }
            }
            catch (Exception e) {
                LogFactory.writeLogEntry(this.getClass(), "Could not execute merge delta " + e.getMessage());
            }
        }
        return 0;
    }

    public int checkForFinishedMerges(Connection connection) {
        PreparedStatement checkMemPrepStmt = null;
        PreparedStatement compressPrepStmt = null;
        try {
            Iterator<TableData> it = this.getCurrentTableDataList().iterator();
            while (it.hasNext()) {
                TableData tableData = it.next();
                String checkMemoryInDeltaStatement = tableData.checkMemoryInDeltaStatement();
                checkMemPrepStmt = connection.prepareStatement(checkMemoryInDeltaStatement);
                int memoryInDeltaMb = 0;
                ResultSet rs = checkMemPrepStmt.executeQuery();
                while (rs.next()) {
                    memoryInDeltaMb = rs.getInt(1);
                }
                if (0 == memoryInDeltaMb) {
                    LogFactory.writeLogEntry(this.getClass(), "Merge delta finished for table " + tableData.tableName + ". Memory size in delta for table " + tableData.tableName + " " + memoryInDeltaMb + " MB.");
                    String compressStatement = tableData.getCompressStatement();
                    compressPrepStmt = connection.prepareStatement(compressStatement);
                    compressPrepStmt.execute();
                    LogFactory.writeLogEntry(this.getClass(), "Run SQL command: " + compressStatement);
                    it.remove();
                    continue;
                }
                tableData.increaseDeltaSizeMbNotChanged();
                tableData.setDeltaSizeMb(memoryInDeltaMb);
                LogFactory.writeLogEntry(this.getClass(), "Delta size for table " + tableData.getTableName() + ": " + memoryInDeltaMb + " MB.");
                if (tableData.getDeltaSizeMbNotChanged() <= 5) continue;
                LogFactory.writeLogEntry(this.getClass(), "Delta size for table " + tableData.getTableName() + " after 5 iterations " + tableData.getDeltaSizeMb() + " MB. Giving up...");
                it.remove();
            }
        }
        catch (Exception e) {
            LogFactory.writeLogEntry(this.getClass(), "Could not check for finished merge delta " + e.getMessage());
        }
        return this.getCurrentTableDataList().size();
    }

    public ResourcesData getCurrentResourcesData() {
        return this.currentResourcesData;
    }

    public boolean performAction(ArrayList<ResourcesData> resourceDataList) throws SQLException {
        ResourcesData currentResourceData = this.getCurrentResourcesData();
        if (null == currentResourceData) {
            LogFactory.writeLogEntry(this.getClass(), "No resource data from database available.");
            return false;
        }
        this.cores = currentResourceData.getCPUcores(this.cores);
        LogFactory.writeLogEntry(this.getClass(), "Host: " + currentResourceData.getHost() + " with CPU usage: " + currentResourceData.getCpuUsage() + " will be used for calculation.");
        int idlePercentage = 100 - currentResourceData.getCpuUsage();
        int freeMemoryPercentage = currentResourceData.getFreeMemoryPercentage();
        int memoryInDeltaPercentage = currentResourceData.getMemoryInDeltaPercentage();
        LogFactory.writeLogEntry(this.getClass(), "Free memory percentage: " + freeMemoryPercentage + "%; CPU idle: " + idlePercentage + "%; Memory in delta percentage: " + memoryInDeltaPercentage + "%;");
        BigInteger memorySizeInDelta = currentResourceData.getMemorySizeInDelta();
        long memorySizeInDeltaMB = Size.getInMB(memorySizeInDelta.longValue());
        if (memoryInDeltaPercentage > 1 || memorySizeInDeltaMB > 10000L) {
            LogFactory.writeLogEntry(this.getClass(), "Merge Delta decision (YES): memoryInDeltaPercentage = " + memoryInDeltaPercentage + " %; memorySizeInDeltaMB = " + memorySizeInDeltaMB + " MB.");
            LogFactory.writeLogEntry(this.getClass(), currentResourceData.toString());
            currentResourceData.computeMergeTokens(this.cores, freeMemoryPercentage, idlePercentage);
            return true;
        }
        LogFactory.writeLogEntry(this.getClass(), "Merge Delta decision (NO): memoryInDeltaPercentage = " + memoryInDeltaPercentage + " %; memorySizeInDeltaMB = " + memorySizeInDeltaMB + " MB.");
        LogFactory.writeLogEntry(this.getClass(), "End of interval");
        return false;
    }

    private long getFreeMemory(ResourcesData resourceData) {
        return resourceData.getFreeMemory().longValue();
    }

    public ArrayList<TableData> getAllTableDataList() {
        return this.allTableDataList;
    }

    public void addTableDataToAll(TableData tableData) {
        this.allTableDataList.add(tableData);
    }

    public TableData removeTableDataFromAll() {
        if (this.allTableDataList.size() > 0) {
            return this.allTableDataList.remove(0);
        }
        return null;
    }

    public ArrayList<TableData> getCurrentTableDataList() {
        return this.currentTableDataList;
    }

    public void setCurrentTableDataList(ArrayList<TableData> currentTableDataList) {
        this.currentTableDataList = currentTableDataList;
    }

    public void addTableDataToCurrent(TableData tableData) {
        this.currentTableDataList.add(tableData);
    }
}

