/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.memory;

import com.sap.hdb.sl.lib.logging.LogFactory;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ResourcesData {
    private String host;
    private int cpuUsage;
    private BigInteger freeMemory;
    private BigInteger usedMemory;
    private BigInteger effectiveAllocationLimit;
    private Timestamp startTimeStamp;
    private Timestamp endTimeStamp;
    private Map<String, String> hostInformationMap = new HashMap<String, String>();
    private BigInteger totalCpuUserTime;
    private BigInteger totalCpuSystemTime;
    private BigInteger totalCpuWioTime;
    private BigInteger totalCpuIdleTime;
    private BigInteger memorySizeInDelta;
    private boolean isMasterHost = false;
    private boolean isScaleOutLandscape = false;
    private int numberOfSlaveNodes = 0;
    private int mergeTokens;

    public ResourcesData(String hostName) {
        this.host = hostName;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getCpuUsage() {
        return this.cpuUsage;
    }

    public void setCpuUsage(int cpuUsage) {
        this.cpuUsage = cpuUsage;
    }

    public BigInteger getFreeMemory() {
        return this.freeMemory;
    }

    public void setFreeMemory(BigInteger freeMemory) {
        this.freeMemory = freeMemory;
    }

    public BigInteger getUsedMemory() {
        return this.usedMemory;
    }

    public void setUsedMemory(BigInteger usedMemory) {
        this.usedMemory = usedMemory;
    }

    public BigInteger getEffectiveAllocationLimit() {
        return this.effectiveAllocationLimit;
    }

    public void setEffectiveAllocationLimit(BigInteger limit) {
        this.effectiveAllocationLimit = limit;
    }

    public Timestamp getStartTimeStamp() {
        return this.startTimeStamp;
    }

    public void setStartTimeStamp(Timestamp startTimeStamp) {
        this.startTimeStamp = startTimeStamp;
    }

    public Timestamp getEndTimeStamp() {
        return this.endTimeStamp;
    }

    public void setEndTimeStamp(Timestamp endTimeStamp) {
        this.endTimeStamp = endTimeStamp;
    }

    public Map<String, String> getHostInformationMap() {
        return this.hostInformationMap;
    }

    public void setHostInformationMap(Map<String, String> hostInformationMap) {
        this.hostInformationMap = hostInformationMap;
    }

    public int getCPUcores(int defaultCores) {
        if (this.hostInformationMap.containsKey("cpu_cores")) {
            String cores = this.hostInformationMap.get("cpu_cores");
            return Integer.parseInt(cores);
        }
        LogFactory.writeLogEntry(this.getClass(), "Using default value for cpu_cores: " + defaultCores);
        return defaultCores;
    }

    public int getCPUthreads(int defaultThreads) {
        if (this.hostInformationMap.containsKey("cpu_threads")) {
            String threads = this.hostInformationMap.get("cpu_threads");
            return Integer.parseInt(threads);
        }
        LogFactory.writeLogEntry(this.getClass(), "Using default value for cpu_threads: " + defaultThreads);
        return defaultThreads;
    }

    public int getFreeMemoryPercentage() {
        BigInteger numerator = this.getFreeMemory().multiply(BigInteger.valueOf(100L));
        BigInteger denominator = this.getEffectiveAllocationLimit();
        return numerator.divide(denominator).intValue();
    }

    public int getMemoryInDeltaPercentage() {
        BigInteger numerator = this.getMemorySizeInDelta().multiply(BigInteger.valueOf(100L));
        BigInteger denominator = this.getEffectiveAllocationLimit();
        return numerator.divide(denominator).intValue();
    }

    public BigInteger getTotalCpuUserTime() {
        return this.totalCpuUserTime;
    }

    public void setTotalCpuUserTime(BigInteger totalCpuUserTime) {
        this.totalCpuUserTime = totalCpuUserTime;
    }

    public BigInteger getTotalCpuSystemTime() {
        return this.totalCpuSystemTime;
    }

    public void setTotalCpuSystemTime(BigInteger totalCpuSystemTime) {
        this.totalCpuSystemTime = totalCpuSystemTime;
    }

    public BigInteger getTotalCpuWioTime() {
        return this.totalCpuWioTime;
    }

    public void setTotalCpuWioTime(BigInteger totalCpuWioTime) {
        this.totalCpuWioTime = totalCpuWioTime;
    }

    public BigInteger getTotalCpuIdleTime() {
        return this.totalCpuIdleTime;
    }

    public void setTotalCpuIdleTime(BigInteger totalCpuIdleTime) {
        this.totalCpuIdleTime = totalCpuIdleTime;
    }

    public void setIsMasterHost(boolean value) {
        this.isMasterHost = value;
    }

    public boolean isMasterHost() {
        return this.isMasterHost;
    }

    public void setScaleOutLandscape(boolean value) {
        this.isScaleOutLandscape = value;
    }

    public boolean isScaleOutLandscape() {
        return this.isScaleOutLandscape;
    }

    private String printMap() {
        StringBuilder builder = new StringBuilder();
        Set<Map.Entry<String, String>> entryset = this.hostInformationMap.entrySet();
        for (Map.Entry<String, String> entry : entryset) {
            builder.append("<" + entry.getKey() + ", " + entry.getValue() + "> ");
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Host: " + this.getHost() + "\n");
        builder.append("CPU Usage: " + this.getCpuUsage() + "% \n");
        builder.append("CPU Cores: " + this.getCPUcores(40) + "\n");
        builder.append("CPU Threads: " + this.getCPUthreads(80) + "\n");
        builder.append("Effectiv Allocation limit: " + this.getEffectiveAllocationLimit() + "\n");
        builder.append("Free Memory: " + this.getFreeMemory() + "\n");
        builder.append("Used Memory: " + this.getUsedMemory() + "\n");
        builder.append("Free Memory including unused allocated%: " + this.getFreeMemoryPercentage() + "% \n");
        builder.append("Start Timestamp: " + this.getStartTimeStamp() + "\n");
        builder.append("End Timestamp: " + this.getEndTimeStamp() + "\n");
        if (this.getEndTimeStamp() != null && this.getStartTimeStamp() != null) {
            builder.append("Timestamps Delta: " + (this.getEndTimeStamp().getTime() - this.getStartTimeStamp().getTime()) + "\n");
        }
        builder.append("Host Information: " + this.printMap() + "\n");
        return builder.toString();
    }

    public void setNumberOfSlaveNodes(int number) {
        this.numberOfSlaveNodes = number;
    }

    public int getNumberOfSlaveNodes() {
        return this.numberOfSlaveNodes;
    }

    public BigInteger getMemorySizeInDelta() {
        return this.memorySizeInDelta;
    }

    public void setMemorySizeInDelta(BigInteger memorySizeInDelta) {
        this.memorySizeInDelta = memorySizeInDelta;
    }

    public void computeMergeTokens(int cores, int freeMemoryPercentage, int idlePercentage) {
        int res;
        LogFactory.writeLogEntry(this.getClass(), "merge tokens = 1 + cores * freeMemoryPercentage/100 * idlePercentage/100");
        this.mergeTokens = res = 1 + cores * freeMemoryPercentage / 100 * idlePercentage / 100;
        LogFactory.writeLogEntry(this.getClass(), "Will merge " + this.mergeTokens + " tables in parallel");
    }

    public int getMergeTokens() {
        return this.mergeTokens;
    }
}

