/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.memory;

public class TableData {
    String schemaName;
    String tableName;
    int deltaSizeMb;
    int mainSizeMb;
    int deltaSizeMbNotChanged = 0;

    public TableData(String schemaName, String tableName, int deltaSizeMb, int mainSizeMb) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.deltaSizeMb = deltaSizeMb;
        this.mainSizeMb = mainSizeMb;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public int getDeltaSizeMb() {
        return this.deltaSizeMb;
    }

    public void setDeltaSizeMb(int deltaSizeMb) {
        this.deltaSizeMb = deltaSizeMb;
    }

    public int getMainSizeMb() {
        return this.mainSizeMb;
    }

    public void setMainSizeMb(int mainSizeMb) {
        this.mainSizeMb = mainSizeMb;
    }

    public String getMergeStatement() {
        StringBuilder sb = new StringBuilder();
        sb.append("MERGE DELTA OF");
        sb.append(" \"").append(this.getSchemaName()).append("\".");
        sb.append("\"").append(this.getTableName()).append("\"");
        return sb.toString();
    }

    public String checkMemoryInDeltaStatement() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ROUND(SUM(MEMORY_SIZE_IN_DELTA/1024/1024)) as MEMORY_SIZE_IN_DELTA_MB FROM SYS.M_CS_TABLES where SCHEMA_NAME =");
        sb.append(" '").append(this.getSchemaName()).append("' ");
        sb.append("and TABLE_NAME =");
        sb.append(" '").append(this.getTableName()).append("'");
        return sb.toString();
    }

    public String getCompressStatement() {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE");
        sb.append(" \"").append(this.getSchemaName()).append("\".");
        sb.append("\"").append(this.getTableName()).append("\"");
        sb.append(" WITH PARAMETERS ('OPTIMIZE_COMPRESSION'='YES')");
        return sb.toString();
    }

    public int getDeltaSizeMbNotChanged() {
        return this.deltaSizeMbNotChanged;
    }

    public void increaseDeltaSizeMbNotChanged() {
        ++this.deltaSizeMbNotChanged;
    }
}

