/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.operating.system;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.logging.LogEvent;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.logging.LogManager;
import com.sap.hdb.sl.lib.logging.LogWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ExternalProcess {
    private List<Exception> mExceptions = new ArrayList<Exception>();
    private LogWriter logWriter = null;
    private LogManager logManager = null;
    protected String cmdLine = "";
    protected int toolRc = 0;
    protected int exitValue = 0;
    protected List<String> toolMessageList = new ArrayList<String>();
    protected String toolMessage = "";
    protected List<String> resltList = new ArrayList<String>();

    protected String getCmdAsString() {
        return this.cmdLine;
    }

    protected void execute(String[] cmd) {
        this.exec(cmd, null, null, null);
    }

    protected void execute(String[] cmd, String[] input) {
        this.exec(cmd, input, null, null);
    }

    protected void execute(String[] cmd, String[] envp, File dir) {
        this.exec(cmd, null, envp, dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec(String[] cmd, String[] input, String[] envp, File dir) {
        this.exitValue = 0;
        this.toolRc = 0;
        this.toolMessage = "";
        this.toolMessageList = new ArrayList<String>();
        this.resltList = new ArrayList<String>();
        this.cmdLine = "";
        for (String s : cmd) {
            this.cmdLine = this.cmdLine + " " + s;
        }
        this.initListener();
        this.localLogger("Use Java process call.");
        this.localLogger("Execute command: " + this.cmdLine);
        try {
            Process process = Runtime.getRuntime().exec(cmd, envp, dir);
            OutputProcessor stdOutProcessor = new OutputProcessor(process.getInputStream());
            stdOutProcessor.start();
            OutputProcessor stdErrProcessor = new OutputProcessor(process.getErrorStream());
            stdErrProcessor.start();
            InputFeeder feeder = new InputFeeder(process.getOutputStream(), input);
            feeder.start();
            try {
                process.waitFor();
                this.exitValue = process.exitValue();
                feeder.join();
                stdOutProcessor.join();
                stdErrProcessor.join();
            }
            catch (InterruptedException e) {
                this.appendException(e);
            }
        }
        catch (Exception e) {
            this.appendException(e);
        }
        finally {
            this.rmListener();
        }
        Iterator<Exception> i$ = this.mExceptions.iterator();
        if (i$.hasNext()) {
            Exception mExc = i$.next();
            String eMessage = mExc.getMessage();
            this.localLogger(eMessage);
            throw new HdbException(eMessage);
        }
        this.checkForToolExc();
    }

    void appendException(Exception e) {
        this.mExceptions.add(e);
    }

    private void initListener() {
        this.logManager = LogFactory.getLogManager();
        this.logWriter = new LogWriter(){

            @Override
            public void append(LogEvent event) {
                ExternalProcess.this.handleStdoutStderr(event.getMessage());
            }
        };
        this.logManager.addLogWriter(this.logWriter);
    }

    protected void handleStdoutStderr(String message) {
        this.resltList.add(message);
        if (null == message || message.length() == 0) {
            this.toolRc = 1;
            this.toolMessageList.add(message);
        }
        this.localLogger(message);
    }

    protected void checkForToolExc() {
        if (this.toolRc != 0) {
            String message = "";
            if (this.toolMessageList.size() > 0) {
                for (String s : this.toolMessageList) {
                    message = message + s + " ";
                }
            } else {
                message = this.toolMessage;
            }
            throw new HdbException("Error during command: " + this.getCmdAsString() + " " + message);
        }
    }

    protected void rmListener() {
        if (this.logWriter != null) {
            this.logManager.removeLogWriter(this.logWriter);
        }
    }

    protected void localLogger(String logText) {
        LogFactory.writeLogEntry(this.getClass(), logText, true);
    }

    protected List<String> getResult() {
        return this.resltList;
    }

    private class InputFeeder
    extends Thread {
        private OutputStream mStrm;
        private String[] mInArry;

        public InputFeeder(OutputStream strm, String[] inArry) {
            this.mStrm = strm;
            this.mInArry = inArry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block13: {
                try {
                    if (this.mInArry == null) break block13;
                    PrintWriter owrtr = null;
                    try {
                        owrtr = new PrintWriter(this.mStrm);
                        for (int i = 0; i < this.mInArry.length; ++i) {
                            owrtr.println(this.mInArry[i]);
                            owrtr.flush();
                        }
                    }
                    finally {
                        if (owrtr != null) {
                            owrtr.close();
                        }
                    }
                }
                finally {
                    if (this.mStrm != null) {
                        try {
                            this.mStrm.close();
                        }
                        catch (IOException e) {
                            ExternalProcess.this.appendException(e);
                        }
                    }
                }
            }
        }
    }

    private class OutputProcessor
    extends Thread {
        private InputStream mStrm;

        public OutputProcessor(InputStream strm) {
            this.mStrm = strm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader outReader = null;
            try {
                String line;
                outReader = new BufferedReader(new InputStreamReader(this.mStrm, "UTF-8"));
                this.setPriority(10);
                while ((line = outReader.readLine()) != null) {
                    ExternalProcess.this.localLogger(line);
                }
            }
            catch (IOException e) {
                ExternalProcess.this.appendException(e);
            }
            finally {
                if (outReader != null) {
                    try {
                        outReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

