/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.operating.system;

import com.sap.hdb.sl.lib.operating.system.HdbEnvironmentVariable;
import com.sap.hdb.sl.lib.operating.system.HdbEnvironmentVariableList;
import com.sap.hdb.sl.lib.operating.system.HdbEnvironmentVariableName;
import com.sap.hdb.sl.lib.operating.system.HdbEnvironmentVariableValue;
import java.util.Locale;
import java.util.Map;

public class HdbEnvironmentFactory {
    private static final String HDB_PREFIX = "HDB_";
    private static Map<String, String> ENV = null;

    public static void setEnv(Map<String, String> envDouble) {
        ENV = envDouble;
    }

    public static HdbEnvironmentVariableList getHdbVariables() {
        HdbEnvironmentVariableList variables = new HdbEnvironmentVariableList();
        Map<String, String> environment = HdbEnvironmentFactory.getEnv();
        for (Map.Entry<String, String> variable : environment.entrySet()) {
            String varName = variable.getKey();
            if (!(varName = varName.toUpperCase(Locale.ENGLISH)).startsWith(HDB_PREFIX)) continue;
            HdbEnvironmentVariable newVariable = HdbEnvironmentFactory.getNewVariable(varName, variable.getValue());
            newVariable.isSet(true);
            variables.add(newVariable);
        }
        return variables;
    }

    private static Map<String, String> getEnv() {
        if (null == ENV) {
            ENV = System.getenv();
        }
        return ENV;
    }

    private static HdbEnvironmentVariable getNewVariable(String name, String value) {
        return new HdbEnvironmentVariable(new HdbEnvironmentVariableName(name), new HdbEnvironmentVariableValue(value));
    }

    public static HdbEnvironmentVariable getVariable(String variableName) {
        HdbEnvironmentVariable variable = null;
        Map<String, String> environment = HdbEnvironmentFactory.getEnv();
        if (environment.containsKey(variableName)) {
            variable = new HdbEnvironmentVariable(new HdbEnvironmentVariableName(variableName), new HdbEnvironmentVariableValue(environment.get(variableName)));
            variable.isSet(true);
        } else {
            variable = new HdbEnvironmentVariable(new HdbEnvironmentVariableName(variableName), new HdbEnvironmentVariableValue());
            variable.isSet(false);
        }
        return variable;
    }
}

