/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.operating.system;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzNameIF;
import java.util.Locale;

public class HdbEnvironmentVariableName {
    private String name = null;

    protected HdbEnvironmentVariableName(String name) {
        if (null == name || name.length() == 0) {
            throw new HdbException(name + " Parameter name must not be null or blank!");
        }
        this.name = name.toUpperCase(Locale.ENGLISH);
    }

    public boolean equals(Object o) {
        if (!(o instanceof HdbEnvironmentVariableName)) {
            return false;
        }
        HdbEnvironmentVariableName n = (HdbEnvironmentVariableName)o;
        return this.name == null ? n.name == null : this.name.equalsIgnoreCase(n.name);
    }

    public boolean equals(String s) {
        return this.name == null ? s == null : this.name.equalsIgnoreCase(s);
    }

    public boolean equals(EnvironmentVariableName e) {
        return this.name == null ? e == null : this.name.equalsIgnoreCase(e.toString());
    }

    public String get() {
        return this.name;
    }

    public boolean containsNoClazzName() {
        boolean containsNo = false;
        for (EnvironmentVariableName variableName : EnvironmentVariableName.values()) {
            if (!variableName.toString().equalsIgnoreCase(this.name)) continue;
            containsNo = true;
        }
        return containsNo;
    }

    public boolean endsWithClazzName(CmdClazzNameIF currentCmdClazzName) {
        return this.name.endsWith(currentCmdClazzName.toString());
    }

    public boolean startsWith(EnvironmentVariableName variableName) {
        return this.name.startsWith(variableName.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public static enum EnvironmentVariableName {
        HDB_INSTALLATION_PARAMETER,
        HDB_UNINSTALLATION_PARAMETER,
        HDB_CMD_CLAZZ_PARAMETER;

    }
}

