/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.operating.system;

import com.sap.hdb.sl.lib.operating.system.ExternalProcess;
import com.sap.hdb.sl.lib.operating.system.OsToolBox;
import com.sap.hdb.sl.lib.operating.system.OsToolboxFactory;
import java.util.List;

public class WinVersion
extends ExternalProcess {
    private String version = null;

    public WinVersion() {
        this.getVersion();
    }

    public String getVersion() {
        OsToolBox os;
        if (null == this.version && (os = OsToolboxFactory.getToolbox()).onWindows()) {
            String[] commandLine = new String[]{"cmd", "/c", "ver"};
            this.execute(commandLine);
            List<String> result = this.getResult();
            for (String line : result) {
                String v = line.replaceAll("[^0-9?!\\.]", "");
                if (v.isEmpty()) continue;
                this.version = v;
            }
        }
        return this.version;
    }

    @Override
    protected void handleStdoutStderr(String message) {
        if (message.contains("Microsoft")) {
            this.resltList.add(message);
        }
    }

    public boolean isVersionSmallerThan(String other) {
        String[] partsMyVersion = this.version.split("\\.");
        String[] partsOtherVersion = other.split("\\.");
        int size = 0;
        size = partsMyVersion.length <= partsOtherVersion.length ? partsMyVersion.length : partsOtherVersion.length;
        for (int i = 0; i < size; ++i) {
            int o;
            int m = Integer.parseInt(partsMyVersion[i]);
            if (m >= (o = Integer.parseInt(partsOtherVersion[i]))) continue;
            return true;
        }
        return false;
    }
}

