/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.security;

import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.mem.HdbsllibMem;
import com.sap.hdb.sl.lib.security.Sapgenpse;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class JavaKeystore {
    private static final String KEYTOOL_KEYPHRASE = "[Keytool_Keyphrase]";
    private static final String DEFAULT_KEYPHRASE = "VA1MPwd_";
    private static final String DEFAULT = "<DEFAULT>";
    private String truststoreName = new String("hdbtruststore");
    private String truststoreCustomName = new String("hdbtruststore_CUSTOM");
    private String keystoreName = Sapgenpse.getKeyCertificateName();
    private String keystoreCustomName = new String("hdbkeystore_CUSTOM");
    private Class<?> Keystore;
    private HdbsllibMem mem = HdbsllibMem.getInstance();
    private String alias = "install_ssl";

    private void callMain(String[] args) {
        try {
            try {
                this.Keystore = ClassLoader.getSystemClassLoader().loadClass("sun.security.tools.KeyTool");
            }
            catch (ClassNotFoundException e) {
                this.Keystore = ClassLoader.getSystemClassLoader().loadClass("sun.security.tools.keytool.Main");
            }
            Method main = this.Keystore.getMethod("main", new String[0].getClass());
            main.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JavaKeystore() {
        PasswordFactory.addGenericPassword(this.getKeyStorePassword());
    }

    public String getDefaultTrustStore() {
        File cust = new File(this.truststoreCustomName);
        if (cust.exists() && cust.isFile()) {
            LogFactory.writeLogEntry(this.getClass(), "Found custom truststore... " + cust.getAbsolutePath());
            return this.truststoreCustomName;
        }
        File trust = new File(this.truststoreName);
        if (trust.exists() && trust.isFile()) {
            LogFactory.writeLogEntry(this.getClass(), "Found existing truststore... " + trust.getAbsolutePath());
            this.listTrustStore();
            return this.truststoreName;
        }
        return null;
    }

    public String getTrustStore(String certificate) {
        String trustStore = this.getDefaultTrustStore();
        if (trustStore == null) {
            trustStore = certificate;
            try {
                File cert = new File(certificate);
                String certName = cert.getName();
                if (cert.exists() && cert.isFile() && certName.toLowerCase(Locale.ENGLISH).indexOf(".pse") > -1) {
                    Sapgenpse genpse = new Sapgenpse();
                    if (certName.toLowerCase(Locale.ENGLISH).equals(Sapgenpse.SAPCLI_PSE)) {
                        genpse.exportPKlist(certificate);
                    } else {
                        genpse.exportRootCertificate(certificate);
                    }
                    trustStore = Sapgenpse.getRootCertificateName();
                }
                List<String> certificates = this.getCertificateList(trustStore);
                Iterator<String> iterator = certificates.iterator();
                int index = 1;
                while (iterator.hasNext()) {
                    String next = iterator.next();
                    this.importCertificate(next, this.alias + "_" + index);
                    if (!trustStore.equals(next)) {
                        new File(next).delete();
                    }
                    ++index;
                }
                this.listTrustStore();
                return this.truststoreName;
            }
            catch (Exception e) {
                LogFactory.writeLogEntry(this.getClass(), e.getMessage());
            }
        }
        return trustStore;
    }

    private List<String> getCertificateList(String truststore) {
        List<String> certificates = new ArrayList<String>();
        int certificateIndex = 0;
        File truststoreFile = new File(truststore);
        if (truststoreFile.exists() && truststoreFile.isFile()) {
            StringBuilder content = new StringBuilder();
            ArrayList<StringBuilder> contentList = new ArrayList<StringBuilder>();
            try {
                String sCurrentLine;
                BufferedReader br = new BufferedReader(new FileReader(truststore));
                while ((sCurrentLine = br.readLine()) != null) {
                    content.append(sCurrentLine).append("\n");
                    if (sCurrentLine.indexOf("-----END") <= -1) continue;
                    ++certificateIndex;
                    contentList.add(content);
                    content = new StringBuilder();
                }
                br.close();
                LogFactory.writeLogEntry(this.getClass(), "Found " + certificateIndex + " certificates in " + truststore + ".");
                if (truststoreFile.getName().endsWith(".cer") && certificateIndex > 1) {
                    LogFactory.writeLogEntry(this.getClass(), truststore + " contains multiple certificates, adding to Java keystore individually.");
                    certificates = this.getCertificatesList(contentList);
                } else {
                    certificates.add(truststore);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return certificates;
    }

    private List<String> getCertificatesList(List<StringBuilder> content) throws FileNotFoundException {
        ArrayList<String> certificates = new ArrayList<String>();
        Iterator<StringBuilder> iterator = content.iterator();
        int index = 1;
        while (iterator.hasNext()) {
            StringBuilder next = iterator.next();
            String outfile = "certificate_" + index + ".cer";
            PrintWriter out = new PrintWriter(outfile);
            out.print(next.toString());
            out.close();
            ++index;
            certificates.add(outfile);
        }
        return certificates;
    }

    private void importCertificate(String certificateFile, String alias) {
        LogFactory.writeLogEntry(this.getClass(), "Importing certificate from " + certificateFile);
        String[] create = new String[]{"-importcert", "-v", "-keystore", this.truststoreName, "-file", certificateFile, "-alias", alias, "-storepass", this.getKeyStorePassword(), "-trustcacerts", "-noprompt", "-debug"};
        try {
            this.callMain(create);
        }
        catch (Exception e) {
            LogFactory.writeLogEntry(this.getClass(), e.getMessage());
        }
    }

    private void deleteCertificateFromTrustStore() {
        String[] delete = new String[]{"-delete", "-keystore", this.truststoreName, "-alias", this.alias, "-storepass", this.getKeyStorePassword(), "-debug"};
        try {
            this.callMain(delete);
        }
        catch (Exception e) {
            LogFactory.writeLogEntry(this.getClass(), e.getMessage());
        }
    }

    private void listTrustStore() {
        String[] list = new String[]{"-list ", "-v ", "-keystore", this.truststoreName, "-storepass", this.getKeyStorePassword(), "-debug"};
        try {
            this.callMain(list);
        }
        catch (Exception e) {
            LogFactory.writeLogEntry(this.getClass(), e.getMessage());
        }
    }

    public String getDefaultKeyStore() {
        File cust = new File(this.keystoreCustomName);
        if (cust.exists() && cust.isFile()) {
            LogFactory.writeLogEntry(this.getClass(), "Found custom keystore: " + cust.getAbsolutePath());
            return this.keystoreCustomName;
        }
        File trust = new File(this.keystoreName);
        if (trust.exists() && trust.isFile()) {
            LogFactory.writeLogEntry(this.getClass(), "Found existing keystore: " + trust.getAbsolutePath());
            return this.keystoreName;
        }
        return null;
    }

    public String getKeyStore(String certificate) {
        String keyStore = this.getDefaultKeyStore();
        if (keyStore == null) {
            File cert = new File(certificate);
            if (!cert.exists()) {
                // empty if block
            }
            if (cert.exists() && cert.isFile() && cert.getName().toLowerCase(Locale.ENGLISH).indexOf(".pse") > -1) {
                try {
                    Sapgenpse genpse = new Sapgenpse();
                    genpse.exportKeyCertificate(certificate);
                    return Sapgenpse.getKeyCertificateName();
                }
                catch (Exception e) {
                    LogFactory.writeLogEntry(this.getClass(), "Error executing sapgenpse: " + e.getMessage());
                }
            }
            return certificate;
        }
        return keyStore;
    }

    public String getKeyStorePassword() {
        String pw = this.mem.read(KEYTOOL_KEYPHRASE);
        if (pw == null) {
            this.mem.save(KEYTOOL_KEYPHRASE, DEFAULT);
        } else if (!pw.equals(DEFAULT)) {
            return pw;
        }
        return DEFAULT_KEYPHRASE;
    }
}

