/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.security;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.operating.system.ExternalProcess;
import com.sap.hdb.sl.lib.operating.system.OsToolBox;
import com.sap.hdb.sl.lib.operating.system.OsToolboxFactory;
import com.sap.hdb.sl.lib.security.JavaKeystore;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Sapgenpse
extends ExternalProcess {
    private String sapgenpseExe = "sapgenpse";
    private static final String rootCertificate = "server_root.crt";
    private static final String keyCertificate = "hdbkeystore.p12";
    private String outputFile = null;
    private String outputString = "";
    private boolean printOutput = true;
    private OsToolBox os = OsToolboxFactory.getToolbox();
    public static String SAPCLI_PSE = "sapcli.pse";
    public static String SAPSRV_PSE = "sapsrv.pse";

    public Sapgenpse() {
        this.sapgenpseExe = this.sapgenpseExe + (this.os.onWindows() ? ".exe" : "");
        String path = System.getenv("SAPINST_EXE_DIR");
        if (null == path) {
            path = System.getenv("DIR_PUT");
        }
        if (null != path) {
            this.sapgenpseExe = path + "/" + this.sapgenpseExe;
        }
    }

    private void checkExecutable() throws HdbException {
        File sapgenpse = new File(this.sapgenpseExe);
        if (!sapgenpse.exists() || !sapgenpse.isFile()) {
            LogFactory.writeLogEntry(this.getClass(), "sapgenpse executable not found: " + this.sapgenpseExe);
            throw new HdbException("sapgenpse executable not found: " + this.sapgenpseExe);
        }
    }

    public Sapgenpse(String exe) {
        this.sapgenpseExe = exe;
    }

    private int executeWithReturn(String[] command) {
        this.execute(command);
        return this.exitValue;
    }

    public String printHelp() {
        LogFactory.writeLogEntry(this.getClass(), "Printing help ");
        String[] help = new String[]{this.sapgenpseExe, "-h"};
        this.execute(help);
        return null;
    }

    public String exportRootCertificate(String certificate) {
        LogFactory.writeLogEntry(this.getClass(), "Exporting root certificate from : " + certificate);
        String[] export = new String[]{this.sapgenpseExe, "export_own_cert", "-r", "-v", "-f", "x509", "-o", Sapgenpse.getRootCertificateName(), "-p", certificate};
        if (this.executeWithReturn(export) == 24) {
            LogFactory.writeLogEntry(this.getClass(), "Exporting self-signed root certificate from : " + certificate);
            export = new String[]{this.sapgenpseExe, "export_own_cert", "-v", "-f", "x509", "-o", Sapgenpse.getRootCertificateName(), "-p", certificate};
            this.execute(export);
        }
        return null;
    }

    public String exportPKlist(String certificate) {
        LogFactory.writeLogEntry(this.getClass(), "Exporting PKlist from : " + certificate);
        this.outputFile = Sapgenpse.getRootCertificateName();
        String[] export = new String[]{this.sapgenpseExe, "maintain_pk", "-l", "PEMlist", "-p", certificate};
        this.execute(export);
        return Sapgenpse.getRootCertificateName();
    }

    public String exportKeyCertificate(String certificate) {
        LogFactory.writeLogEntry(this.getClass(), "Exporting key(s) from : " + certificate);
        String[] export = new String[]{this.sapgenpseExe, "export_p12", "-z", this.getKeyStorePassword(), "-p", certificate, Sapgenpse.getKeyCertificateName()};
        this.execute(export);
        return null;
    }

    public String exportPrivateKey(String certificate) {
        LogFactory.writeLogEntry(this.getClass(), "Exporting key(s) from : " + certificate);
        String[] export = new String[]{this.sapgenpseExe, "export_p8", "-p", certificate, "deleteme.pem"};
        String[] in = new String[]{"", "", "", ""};
        this.execute(export, in);
        return this.readFromFileToString("deleteme.pem");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readFromFileToString(String filename) {
        StringBuilder contentBuilder = new StringBuilder();
        File theFile = new File(filename);
        try {
            String sCurrentLine;
            BufferedReader br = new BufferedReader(new FileReader(filename));
            while ((sCurrentLine = br.readLine()) != null) {
                contentBuilder.append(sCurrentLine).append("\n");
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            theFile.delete();
        }
        return contentBuilder.toString();
    }

    private String getKeyStorePassword() {
        return new JavaKeystore().getKeyStorePassword();
    }

    @Override
    protected void handleStdoutStderr(String message) {
        this.outputString = this.outputString + message;
        if (this.printOutput && this.outputFile != null) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(this.outputFile, true));
                writer.append(message + "\n");
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getRootCertificateName() {
        return rootCertificate;
    }

    public static String getKeyCertificateName() {
        return keyCertificate;
    }
}

