/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.smigr.create.ddl;

import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.smigr.create.ddl.DatabaseReorgClassificationFile;
import com.sap.hdb.sl.lib.smigr.create.ddl.DatabaseReorgInputFile;
import com.sap.hdb.sl.lib.smigr.create.ddl.RowstoreListFile;
import com.sap.hdb.sl.lib.smigr.create.ddl.SqlLstFile;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import java.io.File;

public class SmigrCreateDdlFactory {
    public static SqlLstFile getSqlListFile(CmdClazzParameterMap parameters, boolean isImport) {
        SqlLstFile sqlListFile = new SqlLstFile(parameters, isImport);
        SmigrCreateDdlFactory.checkExistance(sqlListFile.get());
        return sqlListFile;
    }

    public static DatabaseReorgInputFile getDatabaseReorgInputFile(SqlLstFile sqlLstFile) {
        DatabaseReorgInputFile databaseReorgInputFile = sqlLstFile.isImport() && null != sqlLstFile.get().getParentFile() ? new DatabaseReorgInputFile(sqlLstFile.get().getParentFile().getParentFile()) : new DatabaseReorgInputFile(sqlLstFile.get().getParentFile());
        SmigrCreateDdlFactory.checkExistance(databaseReorgInputFile.get());
        return databaseReorgInputFile;
    }

    public static DatabaseReorgClassificationFile getDatabaseReorgClassificationFile(SqlLstFile sqlLstFile) {
        DatabaseReorgClassificationFile reorgFile = sqlLstFile.isImport() && null != sqlLstFile.get().getParentFile() ? new DatabaseReorgClassificationFile(sqlLstFile.get().getParentFile().getParentFile()) : new DatabaseReorgClassificationFile(sqlLstFile.get().getParentFile());
        SmigrCreateDdlFactory.checkExistance(reorgFile.get());
        return reorgFile;
    }

    public static RowstoreListFile getRowstoreListFile(File fileName) {
        RowstoreListFile rowstoreFile = new RowstoreListFile(fileName);
        SmigrCreateDdlFactory.checkExistance(rowstoreFile);
        return rowstoreFile;
    }

    private static void checkExistance(File file) {
        if (!file.exists()) {
            LogFactory.writeLogEntry(SmigrCreateDdlFactory.class, file + " , No such file.");
        }
    }
}

