/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.smigr.create.ddl;

import com.sap.hdb.sl.lib.smigr.create.ddl.SqlFileFilter;
import com.sap.hdb.sl.lib.smigr.create.ddl.SqlFileName;
import com.sap.hdb.sl.lib.smigr.create.ddl.SqlFileReader;
import com.sap.hdb.sl.lib.smigr.create.ddl.SqlTable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SqlFile {
    private File file = null;
    private List<SqlTable> sqlTables = new ArrayList<SqlTable>();
    private SqlFileName sqlFileName = null;

    protected static FileFilter getSqlFileFilter() {
        return new SqlFileFilter();
    }

    protected SqlFile(SqlFileName name, SqlFileReader sqlFileReader) throws IOException {
        this.file = sqlFileReader.get();
        if (this.file.exists()) {
            List<String> lines = sqlFileReader.getLines();
            SqlTable sqlTable = null;
            for (String line : lines) {
                if (!line.startsWith("tab:")) continue;
                String tableName = line.substring("tab:".length()).trim();
                sqlTable = new SqlTable(tableName, this.sqlFileName);
                this.sqlTables.add(sqlTable);
            }
        }
    }

    public Set<String> getColumnStoreTableNames() {
        HashSet<String> result = new HashSet<String>();
        for (SqlTable table : this.sqlTables) {
            result.add(table.getTableName());
        }
        return result;
    }

    public List<SqlTable> getTabNames() {
        return this.sqlTables;
    }

    public SqlFileName getName() {
        return this.sqlFileName;
    }

    public File get() {
        return this.file;
    }
}

