/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.smigr.create.ddl;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.smigr.create.ddl.SqlFile;
import com.sap.hdb.sl.lib.smigr.create.ddl.SqlFileName;
import com.sap.hdb.sl.lib.smigr.create.ddl.SqlFileReader;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqlLstFile {
    private Map<smigrHeaderInformation, String> headerInformation = null;
    private File sqlLstFile = null;
    private ArrayList<SqlFile> sqlFiles = null;
    private boolean isImport = false;

    protected SqlLstFile(String sqlLstFile, boolean isImport) {
        this.sqlLstFile = new File(sqlLstFile);
        this.isImport = isImport;
        File currentDirectory = this.sqlLstFile.getParentFile();
        this.headerInformation = new HashMap<smigrHeaderInformation, String>();
        this.sqlFiles = new ArrayList();
        BufferedReader fileReader = null;
        if (this.sqlLstFile.exists()) {
            try {
                fileReader = new BufferedReader(new FileReader(this.sqlLstFile));
                String line = fileReader.readLine();
                while (line != null) {
                    if (line.contains("GENERATED")) {
                        this.headerInformation.put(smigrHeaderInformation.EXECUTION_TIME, line);
                    } else if (line.contains(smigrHeaderInformation.SMIGR_CREATE_DDL_VERSION.toString())) {
                        this.headerInformation.put(smigrHeaderInformation.SMIGR_CREATE_DDL_VERSION, line.substring(line.indexOf(":") + 1).trim());
                    } else if (line.contains(smigrHeaderInformation.TARGET_DATABASE.toString())) {
                        this.headerInformation.put(smigrHeaderInformation.TARGET_DATABASE, line.substring(line.indexOf(":") + 1).trim());
                    } else if (line.contains(smigrHeaderInformation.WORK_DIRECTORY.toString())) {
                        this.headerInformation.put(smigrHeaderInformation.WORK_DIRECTORY, line.substring(line.indexOf(":") + 1).trim());
                    } else if (line.contains(smigrHeaderInformation.GENERATED_FILES.toString())) {
                        this.headerInformation.put(smigrHeaderInformation.GENERATED_FILES, line.substring(line.indexOf(":") + 1).trim());
                    } else if (!line.isEmpty() && !line.startsWith("#")) {
                        File sqlFile = new File(currentDirectory, line.trim());
                        SqlFileName sqlFileName = new SqlFileName(sqlFile);
                        this.sqlFiles.add(new SqlFile(sqlFileName, new SqlFileReader(sqlFile)));
                    }
                    line = fileReader.readLine();
                }
            }
            catch (IOException e) {
                throw new HdbException(e);
            }
            finally {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    protected SqlLstFile(CmdClazzParameterMap cmdClazzParameterMap, boolean isImport) {
        this(cmdClazzParameterMap.get(CmdClazzParameterName.SQL_LIST_FILE).getValue(), isImport);
    }

    public File get() {
        return this.sqlLstFile;
    }

    public List<SqlFile> getSqlFiles() {
        return this.sqlFiles;
    }

    public boolean hasHeaderInformation() {
        boolean hasInformation = false;
        if (this.headerInformation.size() > 0) {
            hasInformation = true;
        }
        return hasInformation;
    }

    public Map<smigrHeaderInformation, String> getHeaderInformation() {
        return this.headerInformation;
    }

    public boolean isImport() {
        return this.isImport;
    }

    public static enum smigrHeaderInformation {
        EXECUTION_TIME,
        SMIGR_CREATE_DDL_VERSION,
        TARGET_DATABASE,
        WORK_DIRECTORY,
        GENERATED_FILES;

    }
}

