/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user;

import com.sap.hdb.sl.lib.connection.sql.Hdbsql;
import com.sap.hdb.sl.lib.connection.sql.HdbsqlExecutable;
import com.sap.hdb.sl.lib.exceptions.HdbsqlException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import java.util.List;

public class DatabaseHdbsqlUser
extends DatabaseSqlUser {
    private String key = null;
    private HdbsqlExecutable hdbsqlExec = null;

    public DatabaseHdbsqlUser(String key, HdbsqlExecutable hdbsqlExec) {
        this.key = key;
        this.hdbsqlExec = hdbsqlExec;
        this.useJdbc = false;
        this.findUserName();
    }

    private void findUserName() {
        List<String> resList;
        Hdbsql hdbsql = new Hdbsql(this.getHdbsqlExecutable(), this.getKey());
        try {
            resList = hdbsql.execute("SELECT CURRENT_USER FROM DUMMY");
        }
        catch (HdbsqlException e) {
            LogFactory.writeLogEntry(this.getClass(), e.getMessage());
            throw e;
        }
        String userName = resList.get(0);
        DatabaseSqlUserName name = new DatabaseSqlUserName(userName);
        this.setName(name);
    }

    @Override
    public DatabaseSqlUserName getName() {
        return this.name;
    }

    public void setName(DatabaseSqlUserName name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public HdbsqlExecutable getHdbsqlExecutable() {
        return this.hdbsqlExec;
    }

    @Override
    public String toString() {
        return this.name.get();
    }
}

