/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.security.Sapgenpse;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.user.PasswordPolicy;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import com.sap.hdb.sl.lib.user.password.DatabaseSqlUserPassword;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DatabaseSqlUser
implements DatabaseUser {
    protected boolean useJdbc = true;
    private String defaultUserGroup = "ABAPUSERGROUP";
    protected DatabaseSqlUserName name = null;
    private DatabaseSqlUserPassword password = null;
    private String currentUserGroup = null;
    private String x509CertificatePath = null;
    private String x509PemString = null;

    public boolean useJdbc() {
        return this.useJdbc;
    }

    protected DatabaseSqlUser() {
    }

    protected DatabaseSqlUser(DatabaseSqlUserName name) {
        this.name = name;
    }

    @Override
    public DatabaseSqlUserName getName() {
        return this.name;
    }

    @Override
    public DatabaseSqlUserPassword getPassword() {
        return this.password;
    }

    public void setPassword(DatabaseSqlUserPassword password) {
        this.password = password;
    }

    public String toString() {
        return this.name.get();
    }

    public boolean exists(JdbcConnection connection, DatabaseSystemUser systemUser) {
        boolean exist = false;
        String userName = this.name.get();
        userName = userName.toUpperCase(Locale.ENGLISH);
        connection.setConnectUser(systemUser);
        List<String> result = connection.executeSQLCommand("SELECT USER_NAME FROM SYS.USERS WHERE USER_NAME = '" + userName + "'");
        if (result.size() == 1) {
            exist = true;
        }
        return exist;
    }

    public void dropUser(JdbcConnection connection, DatabaseSystemUser systemUser) {
        connection.setConnectUser(systemUser);
        connection.executeSQLCommandNoReslt("DROP USER " + this.name.get() + " CASCADE");
    }

    public void recreateUser(JdbcConnection connection, DatabaseSystemUser systemUser) {
        if (this.exists(connection, systemUser)) {
            this.dropUser(connection, systemUser);
        }
        this.createNewUser(connection, systemUser);
    }

    public void createNewUser(JdbcConnection connection, DatabaseSystemUser systemUser) {
        connection.setConnectUser(systemUser);
        String passw = this.password.get();
        String passwordWithoutSpecialChars = passw.replaceAll("\"", "\"\"");
        this.createUser(connection, passwordWithoutSpecialChars);
    }

    private void createUser(JdbcConnection connection, String passwordWithoutSpecialChars) {
        String no_force_first_password_change_option = "";
        if (connection.isProductVersionEqualOrGreaterThan("1.00.110.00.1447753075")) {
            no_force_first_password_change_option = " NO FORCE_FIRST_PASSWORD_CHANGE";
        }
        if (!this.hasUserAdminPrivilege(connection)) {
            this.maintainUserGroup(connection);
            connection.executeSQLCommandNoReslt("CREATE USER " + this.name.get() + " PASSWORD \"" + passwordWithoutSpecialChars + "\"" + no_force_first_password_change_option + " SET USERGROUP " + this.defaultUserGroup);
        } else {
            connection.executeSQLCommandNoReslt("CREATE USER " + this.name.get() + " PASSWORD \"" + passwordWithoutSpecialChars + "\"" + no_force_first_password_change_option);
        }
    }

    public void recreateNewUserAlterPassword(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUserPassword finalPassword) {
        if (this.exists(connection, systemUser)) {
            this.dropUser(connection, systemUser);
        }
        this.createNewUserAlterPassword(connection, systemUser, finalPassword);
    }

    private boolean hasUserAdminPrivilege(JdbcConnection connection) {
        String sql = "SELECT HASSYSTEMPRIVILEGE(CURRENT_USER, 'USER ADMIN') FROM SYS.DUMMY";
        List<String> result = connection.executeSQLCommand(sql);
        return result.get(0).equals("1");
    }

    private void maintainUserGroup(JdbcConnection connection) {
        String usergroupsSql = "select count(*) from SYS.USERGROUPS where USERGROUP_NAME = '" + this.defaultUserGroup + "'";
        String createUsergroupSql = "call system.create_usergroup('" + this.defaultUserGroup + "');";
        List<String> result = connection.executeSQLCommand(usergroupsSql);
        if (!result.get(0).equals("1")) {
            connection.executeSQLCommandNoReslt(createUsergroupSql);
        }
    }

    public void createNewUserAlterPassword(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUserPassword finalPassword) {
        connection.setConnectUser(systemUser);
        String finalPasswordWithoutSpecialChars = finalPassword.toString().replaceAll("\"", "\"\"");
        String initialPassword = "x" + finalPasswordWithoutSpecialChars + "x";
        this.createUser(connection, initialPassword);
        this.setPassword(PasswordFactory.getDatabaseSqlUserPassword(initialPassword));
        this.setPassword(PasswordFactory.getDatabaseSqlUserPassword(initialPassword));
        connection.setConnectUser(this);
        this.alterPassword(connection, finalPassword);
    }

    public void alterPassword(JdbcConnection connection, DatabaseSqlUserPassword newPassword) {
        connection.setConnectUser(this);
        String newPasswordWithoutSpecialChars = newPassword.getValue().replaceAll("\"", "\"\"");
        connection.executeSQLCommandNoReslt("ALTER USER " + this.name.get() + " PASSWORD \"" + newPasswordWithoutSpecialChars + "\"");
        this.password = newPassword;
    }

    public void alterPassword(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUserPassword finalPassword) {
        connection.setConnectUser(systemUser);
        String initialPassword = "x" + finalPassword + "x";
        connection.executeSQLCommandNoReslt("ALTER USER " + this.name.get() + " PASSWORD \"" + initialPassword.replaceAll("\"", "\"\"") + "\"");
        this.setPassword(PasswordFactory.getDatabaseSqlUserPassword(initialPassword));
        connection.setConnectUser(this);
        this.alterPassword(connection, finalPassword);
    }

    public Date getCreateDate(JdbcConnection connection, DatabaseSystemUser systemUser) {
        if (!this.exists(connection, systemUser)) {
            throw new HdbException(this.name.get() + ", User does not exist!");
        }
        Calendar fulldate = GregorianCalendar.getInstance();
        connection.setConnectUser(systemUser);
        PreparedStatement stmt = connection.prepareSQLCommand("select create_time from SYS.USERS where user_name = ?");
        try {
            stmt.setString(1, this.name.get());
            stmt.execute();
            ResultSet result = stmt.getResultSet();
            while (result.next()) {
                fulldate.setTime(result.getDate(1));
            }
        }
        catch (SQLException e) {
            throw new HdbException(e);
        }
        return fulldate.getTime();
    }

    public String getX509PemString() {
        return this.x509PemString;
    }

    public String getX509CertPath() {
        return this.x509CertificatePath;
    }

    public void setX509Certificate(File file) {
        try {
            this.x509CertificatePath = file.getAbsolutePath();
            if (this.x509CertificatePath.toLowerCase(Locale.ENGLISH).endsWith(".pem")) {
                String line;
                FileReader fr = new FileReader(file);
                BufferedReader br = new BufferedReader(fr);
                StringBuffer sb = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
                fr.close();
                this.x509PemString = sb.toString();
            }
            if (this.x509CertificatePath.toLowerCase(Locale.ENGLISH).endsWith(".pse")) {
                Sapgenpse genpse = new Sapgenpse();
                this.x509PemString = genpse.exportPrivateKey(this.x509CertificatePath);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setX509Certificate(String pemstring) {
        this.x509PemString = pemstring;
    }

    public boolean useCertificateForAuth() {
        return this.x509CertificatePath != null || this.x509PemString != null;
    }

    public Map<String, String> getCurrentUserGroupPolicy(JdbcConnection connection, DatabaseSystemUser systemUser) {
        this.getUsergroup(connection);
        if (this.currentUserGroup == null) {
            return null;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (PasswordPolicy.PasswordProperty property : PasswordPolicy.PasswordProperty.values()) {
            parameterNames.add(property.toString());
        }
        for (String name : parameterNames) {
            String setValue = this.getUserGroupPolicyValue(connection, name);
            if (setValue == null) continue;
            parameters.put(name, setValue);
        }
        return parameters;
    }

    private String getUsergroup(JdbcConnection connection) {
        if (this.currentUserGroup == null && connection.supports_USER_GROUPS()) {
            String sql = "SELECT USERGROUP_NAME FROM USERS WHERE USER_NAME = '" + this.getName().getValue() + "'";
            List<String> result = connection.executeSQLCommand(sql);
            if (result.size() == 1) {
                this.currentUserGroup = result.get(0);
            } else if (result.size() < 1) {
                // empty if block
            }
        }
        return this.currentUserGroup;
    }

    public String getUserGroupPolicyValue(JdbcConnection connection, String name) {
        List<Object> result = Collections.emptyList();
        result = connection.executeSQLCommand("SELECT VALUE from \"PUBLIC\".\"M_EFFECTIVE_PASSWORD_POLICY\" WHERE USER_NAME = '" + this.getName().getValue() + "' AND PROPERTY = '" + name + "'");
        if (result.size() == 1) {
            return (String)result.get(0);
        }
        return null;
    }

    public void setUserGroupPolicyValue(JdbcConnection connection, String name, String value) {
        connection.executeSQLCommand("ALTER USERGROUP " + this.getUsergroup(connection) + " SET PARAMETER '" + name.toLowerCase(Locale.ENGLISH) + "' = '" + value + "'");
    }

    public void setCurrentUserGroupPolicy(JdbcConnection connection, DatabaseSystemUser systemUser, Map<String, String> usergroupPolicy) {
        for (Map.Entry<String, String> e : usergroupPolicy.entrySet()) {
            this.setUserGroupPolicyValue(connection, e.getKey(), e.getValue());
        }
    }
}

