/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user;

import com.sap.hdb.sl.lib.connection.sql.HdbsqlExecutable;
import com.sap.hdb.sl.lib.user.DatabaseHdbsqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import com.sap.hdb.sl.lib.user.password.DatabaseSqlUserPassword;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import java.io.File;

public class DatabaseSqlUserFactory {
    private DatabaseSqlUserFactory() {
    }

    public static DatabaseSqlUser getUser(CmdClazzParameterMap parameters) {
        if (parameters.containsKey(CmdClazzParameterName.USE_HDBUSERSTORE_KEY)) {
            String keyValue = "DEFAULT";
            String clientPath = null;
            if (parameters.containsKey(CmdClazzParameterName.USERSTORE_KEY_NAME)) {
                keyValue = parameters.get(CmdClazzParameterName.USERSTORE_KEY_NAME).getValue();
            }
            if (parameters.containsKey(CmdClazzParameterName.CLIENT_SOFTWARE_PATH)) {
                clientPath = parameters.get(CmdClazzParameterName.CLIENT_SOFTWARE_PATH).getValue();
            }
            HdbsqlExecutable hdbsqlExec = new HdbsqlExecutable(clientPath);
            DatabaseHdbsqlUser sqlUser = new DatabaseHdbsqlUser(keyValue, hdbsqlExec);
            return sqlUser;
        }
        DatabaseSqlUserName userName = new DatabaseSqlUserName(parameters.get(CmdClazzParameterName.DATABASE_SQL_USER_NAME).getValue());
        DatabaseSqlUser sqlUser = new DatabaseSqlUser(userName);
        if (parameters.containsKey(CmdClazzParameterName.DATABASE_SQL_USER_PASSWORD)) {
            DatabaseSqlUserPassword password = PasswordFactory.getDatabaseSqlUserPassword(parameters.get(CmdClazzParameterName.DATABASE_SQL_USER_PASSWORD).getValue());
            sqlUser.setPassword(password);
        }
        if (parameters.containsKey(CmdClazzParameterName.DATABASE_SQL_USER_X509_CERTIFICATE)) {
            sqlUser.setX509Certificate(new File(parameters.get(CmdClazzParameterName.DATABASE_SQL_USER_X509_CERTIFICATE).getValue()));
        } else if (parameters.containsKey(CmdClazzParameterName.DATABASE_SQL_USER_X509_PEM_STRING)) {
            sqlUser.setX509Certificate(parameters.get(CmdClazzParameterName.DATABASE_SQL_USER_X509_PEM_STRING).getValue());
        }
        return sqlUser;
    }

    public static DatabaseSqlUser getUser(DatabaseSqlUserName name) {
        return new DatabaseSqlUser(name);
    }

    public static DatabaseSqlUser getUser(DatabaseSqlUserName name, DatabaseSqlUserPassword password) {
        DatabaseSqlUser user = new DatabaseSqlUser(name);
        user.setPassword(password);
        return user;
    }
}

