/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.user.name.DatabaseSystemUserName;
import com.sap.hdb.sl.lib.user.password.DatabaseSystemUserPassword;
import java.util.List;

public class DatabaseSystemUser
implements DatabaseUser {
    private static final String USER_ADMIN = "USER ADMIN";
    private DatabaseSystemUserName name = null;
    private DatabaseSystemUserPassword password = null;

    protected DatabaseSystemUser() {
        this.name = new DatabaseSystemUserName();
    }

    protected DatabaseSystemUser(DatabaseSystemUserName name) {
        this.name = name;
    }

    @Override
    public DatabaseSystemUserName getName() {
        return this.name;
    }

    public void setName(DatabaseSystemUserName name) {
        this.name = name;
    }

    @Override
    public DatabaseSystemUserPassword getPassword() {
        return this.password;
    }

    public void setPassword(DatabaseSystemUserPassword password) {
        this.password = password;
    }

    public String toString() {
        return this.name.get();
    }

    public void alterPassword(JdbcConnection connection, DatabaseSystemUserPassword newPassword) {
        connection.setConnectUser(this);
        String newPasswordWithoutSpecialChars = newPassword.getValue().replaceAll("\"", "\"\"");
        connection.executeSQLCommandNoReslt("ALTER USER " + this.name.get() + " PASSWORD \"" + newPasswordWithoutSpecialChars + "\"");
        this.password = newPassword;
    }

    public void adminUserOK(JdbcConnection connection) {
        if (connection.isHANA4orNewer()) {
            if (!"DBADMIN".equalsIgnoreCase(this.name.get())) {
                throw new HdbException("[INVALID_ADMIN_USER] Only DBADMIN can be used as an admin user on SAP HANA Cloud Edition version " + connection.getDbVersion() + ".");
            }
        } else if (!"SYSTEM".equalsIgnoreCase(this.name.get())) {
            throw new HdbException("[INVALID_ADMIN_USER] Only SYSTEM can be used as an admin user on SAP HANA on Premise version " + connection.getDbVersion() + ".");
        }
    }

    private boolean hasSystemPrivilege(JdbcConnection connection, String privilege) {
        String sql = "SELECT HASSYSTEMPRIVILEGE(CURRENT_USER, '" + privilege + "') FROM SYS.DUMMY";
        List<String> result = connection.executeSQLCommand(sql);
        return result.get(0).equals("1");
    }
}

