/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user;

import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseUserAdmin;
import com.sap.hdb.sl.lib.user.SystemDatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.name.DatabaseSystemUserName;
import com.sap.hdb.sl.lib.user.password.DatabaseSystemUserPassword;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;

public class DatabaseSystemUserFactory {
    private DatabaseSystemUserFactory() {
    }

    public static DatabaseSystemUser getUser(CmdClazzParameterMap parameters) {
        DatabaseUserAdmin adminUser;
        DatabaseSystemUser systemUser = null;
        if (parameters.containsKey(CmdClazzParameterName.DATABASE_SYSTEM_USER_NAME)) {
            DatabaseSystemUserName userName = new DatabaseSystemUserName(parameters.get(CmdClazzParameterName.DATABASE_SYSTEM_USER_NAME).getValue());
            systemUser = new DatabaseSystemUser(userName);
        } else {
            systemUser = new DatabaseSystemUser();
        }
        if (parameters.containsKey(CmdClazzParameterName.DATABASE_USER_ADMIN_NAME) && parameters.containsKey(CmdClazzParameterName.DATABASE_USER_ADMIN_PASSWORD) && (adminUser = DatabaseUserAdmin.getInstance(parameters)).isSystemUserDeactivated()) {
            adminUser.activate();
        }
        DatabaseSystemUserPassword password = new DatabaseSystemUserPassword(parameters);
        systemUser.setPassword(password);
        return systemUser;
    }

    public static DatabaseSystemUser getUser() {
        return new DatabaseSystemUser();
    }

    public static DatabaseSystemUser getUser(DatabaseSystemUserPassword password) {
        DatabaseSystemUser system = new DatabaseSystemUser();
        system.setPassword(password);
        return system;
    }

    public static DatabaseSystemUser getUser(CmdClazzParameterMap parameters, Database database) {
        DatabaseSystemUser systemUser = database.isSystemDB() ? SystemDatabaseSystemUserFactory.getUser(parameters) : DatabaseSystemUserFactory.getUser(parameters);
        return systemUser;
    }
}

