/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.mem.HdbsllibMem;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import com.sap.hdb.sl.lib.user.password.DatabaseSqlUserPassword;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import java.util.List;
import java.util.Locale;

public class DatabaseUserAdmin
extends DatabaseSqlUser {
    private static DatabaseSqlUserName name = null;
    private static DatabaseSqlUserPassword password = null;
    private static JdbcConnection connection = null;
    private static DatabaseUserAdmin USER_ADMIN = null;
    private static boolean deactivated = false;
    private static String initialStateDeactivated = null;
    public static String INITIAL_STATE_SYSTEM_DEACTIVATED = "[Initial_State_SYSTEM_Deactivated]";

    private DatabaseUserAdmin(DatabaseSqlUserName sysAdminname, DatabaseSqlUserPassword sysAdminPass) {
        name = sysAdminname;
        password = sysAdminPass;
    }

    public static DatabaseUserAdmin getInstance(CmdClazzParameterMap parameters) {
        if (null == USER_ADMIN) {
            DatabaseSqlUserName sysAdminName = new DatabaseSqlUserName(parameters.get(CmdClazzParameterName.DATABASE_USER_ADMIN_NAME).getValue());
            Database database = InstanceFactory.getDatabaseInstance(parameters);
            JdbcDriver jdbcDriver = new JdbcDriver(parameters);
            JdbcConnection noReconnect = JdbcConnectionFactory.getInstanceNoReconnect(jdbcDriver, database);
            DatabaseSqlUserPassword sysAdminPass = PasswordFactory.getDatabaseSqlUserPassword(parameters.get(CmdClazzParameterName.DATABASE_USER_ADMIN_PASSWORD).getValue());
            USER_ADMIN = new DatabaseUserAdmin(sysAdminName, sysAdminPass);
            noReconnect.setConnectUser(USER_ADMIN);
            connection = noReconnect;
        }
        return USER_ADMIN;
    }

    public static DatabaseUserAdmin getInstance() {
        return USER_ADMIN;
    }

    @Override
    public DatabaseSqlUserName getName() {
        return name;
    }

    @Override
    public DatabaseSqlUserPassword getPassword() {
        return password;
    }

    @Override
    public String toString() {
        return name.get();
    }

    public void deactivate() {
        connection.executeSQLCommandNoReslt("ALTER USER SYSTEM DEACTIVATE USER NOW");
        deactivated = true;
    }

    public void activate() {
        connection.executeSQLCommandNoReslt("ALTER USER SYSTEM ACTIVATE USER NOW");
        deactivated = false;
    }

    public boolean isSystemUserDeactivated() {
        if (null == initialStateDeactivated) {
            List<String> result = null;
            try {
                result = connection.executeSQLCommand("SELECT USER_DEACTIVATED FROM SYS.USERS WHERE USER_NAME = 'SYSTEM'");
            }
            catch (HdbException e) {
                LogFactory.writeLogEntry(this.getClass(), "Could not check if SYSTEM USER_DEACTIVATED. User " + this.getName() + " does not exist or the password is not correct.");
                LogFactory.writeLogEntry(this.getClass(), "Assume that SYSTEM user is active and continue...");
                deactivated = false;
                initialStateDeactivated = "false";
                return deactivated;
            }
            String res = result.get(0);
            if (null == res) {
                LogFactory.writeLogEntry(this.getClass(), "Could not check if SYSTEM USER_DEACTIVATED. Check if user " + this.getName() + " has USER ADMIN role!");
                deactivated = false;
                initialStateDeactivated = "false";
            } else {
                LogFactory.writeLogEntry(this.getClass(), "USER_DEACTIVATED for SYSTEM user is " + res);
                deactivated = res.toUpperCase(Locale.ENGLISH).equals("TRUE");
                initialStateDeactivated = res;
                HdbsllibMem mem = HdbsllibMem.getInstance();
                if (null == mem.read(INITIAL_STATE_SYSTEM_DEACTIVATED)) {
                    mem.save(INITIAL_STATE_SYSTEM_DEACTIVATED, initialStateDeactivated);
                }
            }
        }
        return deactivated;
    }

    public static boolean wasInitialStateDeactivated() {
        HdbsllibMem mem = HdbsllibMem.getInstance();
        String state = mem.read(INITIAL_STATE_SYSTEM_DEACTIVATED);
        if (null == state) {
            return false;
        }
        return state.toUpperCase(Locale.ENGLISH).equals("TRUE");
    }

    public void resetInitialState() {
        HdbsllibMem mem = HdbsllibMem.getInstance();
        mem.delete(INITIAL_STATE_SYSTEM_DEACTIVATED);
    }
}

