/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PasswordPolicy {
    private JdbcConnection connection = null;
    private DatabaseSystemUser systemUser = null;

    public static void disableCurrentPolicy(JdbcConnection connection, DatabaseSystemUser systemUser) {
        DatabaseConfigurationSection section = PasswordPolicy.getPolicyConfigurationSection(connection, systemUser);
        for (PasswordProperty property : PasswordProperty.values()) {
            if (!property.hasDisableValue()) continue;
            try {
                section.setParameter(property.toString(), property.getDisabledValue());
            }
            catch (HdbException e) {
                if (property.hasDisableOptionalValue()) {
                    section.setParameter(property.toString(), property.getDisabledOptionalValue());
                    continue;
                }
                throw e;
            }
        }
    }

    public static void disableCurrentPolicy(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser) {
        PasswordPolicy.disableCurrentPolicy(connection, systemUser);
        for (PasswordProperty property : PasswordProperty.values()) {
            if (!property.hasDisableValue()) continue;
            try {
                sqlUser.setUserGroupPolicyValue(connection, property.name(), property.getDisabledValue());
            }
            catch (HdbException e) {
                if (property.hasDisableOptionalValue()) {
                    sqlUser.setUserGroupPolicyValue(connection, property.name(), property.getDisabledOptionalValue());
                    continue;
                }
                throw e;
            }
        }
    }

    public static void setPolicy(JdbcConnection connection, DatabaseSystemUser systemUser, Map<String, String> parameterBackup) {
        DatabaseConfigurationSection section = PasswordPolicy.getPolicyConfigurationSection(connection, systemUser);
        section.setParameters(parameterBackup);
    }

    public static HashMap<String, String> getCurrentPolicy(JdbcConnection connection, DatabaseSystemUser systemUser) {
        DatabaseConfigurationSection section = PasswordPolicy.getPolicyConfigurationSection(connection, systemUser);
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (PasswordProperty property : PasswordProperty.values()) {
            parameterNames.add(property.toString());
        }
        return section.getParameters(parameterNames.toArray(new String[parameterNames.size()]));
    }

    public static String getParameterValue(JdbcConnection connection, DatabaseSystemUser systemUser, String parameterName) {
        DatabaseConfigurationSection section = PasswordPolicy.getPolicyConfigurationSection(connection, systemUser);
        return section.getParameterValue(parameterName);
    }

    public static String getSystemDbParameterValue(JdbcConnection connection, DatabaseSystemUser systemUser, String parameterName) {
        DatabaseConfigurationSection section = PasswordPolicy.getSystemDbPolicyConfigurationSection(connection, systemUser);
        return section.getParameterValue(parameterName);
    }

    private static DatabaseConfigurationSection getPolicyConfigurationSection(JdbcConnection connection, DatabaseSystemUser systemUser) {
        DatabaseConfiguration configuration = new DatabaseConfiguration(connection, systemUser, DatabaseConfiguration.ConfigFileName.INDEXSERVER_INI);
        DatabaseConfigurationSection section = configuration.getSection("password policy");
        return section;
    }

    private static DatabaseConfigurationSection getSystemDbPolicyConfigurationSection(JdbcConnection connection, DatabaseSystemUser systemUser) {
        DatabaseConfiguration configuration = new DatabaseConfiguration(connection, systemUser, DatabaseConfiguration.ConfigFileName.NAMESERVER_INI);
        DatabaseConfigurationSection section = configuration.getSection("password policy");
        return section;
    }

    public PasswordPolicy(JdbcConnection connection, DatabaseSystemUser systemUser) {
        this.connection = connection;
        this.systemUser = systemUser;
    }

    public void disableProperty(PasswordProperty property, DatabaseSqlUser sqlUser) {
        this.connection.setConnectUser(this.systemUser);
        switch (property) {
            case MAXIMUM_PASSWORD_LIFETIME: 
            case MINIMUM_PASSWORD_LIFETIME: 
            case MAXIMUM_UNUSED_PRODUCTIVE_PASSWORD_LIFETIME: {
                this.connection.executeSQLCommand("ALTER USER " + sqlUser.getName().get() + " DISABLE PASSWORD LIFETIME");
                break;
            }
            case LAST_USED_PASSWORDS: {
                DatabaseConfigurationSection section = PasswordPolicy.getPolicyConfigurationSection(this.connection, this.systemUser);
                if (property.hasDisableValue()) {
                    section.setParameter(property.toString(), property.getDisabledValue());
                    break;
                }
                throw new HdbException((Object)((Object)property) + " Property has no disable value!");
            }
            default: {
                throw new HdbException((Object)((Object)property) + " Can't disable password property!");
            }
        }
    }

    public String getValue(PasswordProperty property, DatabaseSqlUser sqlUser) {
        String value = "";
        this.connection.setConnectUser(this.systemUser);
        switch (property) {
            case MAXIMUM_PASSWORD_LIFETIME: 
            case MINIMUM_PASSWORD_LIFETIME: 
            case MAXIMUM_UNUSED_PRODUCTIVE_PASSWORD_LIFETIME: {
                List<String> result = this.connection.executeSQLCommand("SELECT PASSWORD_CHANGE_TIME FROM SYS.USERS WHERE USER_NAME ='" + sqlUser.getName().get() + "'");
                value = result.get(0);
                break;
            }
        }
        return value;
    }

    public boolean isPropertyDisabled(PasswordProperty property, DatabaseSqlUser sqlUser) {
        boolean disabled = false;
        String value = this.getValue(property, sqlUser);
        if (null == value) {
            disabled = true;
        }
        return disabled;
    }

    public static enum PasswordProperty {
        MAXIMUM_PASSWORD_LIFETIME(false, null),
        MINIMUM_PASSWORD_LIFETIME(true, "0"),
        MAXIMUM_UNUSED_PRODUCTIVE_PASSWORD_LIFETIME(false, null),
        LAST_USED_PASSWORDS(true, "0");

        private String disabledValue;
        private String disabledOptionalValue;
        private boolean hasDisableValue = false;

        private PasswordProperty(boolean useForDisabling, String disabledValue) {
            this.hasDisableValue = useForDisabling;
            this.disabledValue = disabledValue;
        }

        private PasswordProperty(boolean useForDisabling, String disabledValue, String disabledOptionalValue) {
            this.hasDisableValue = useForDisabling;
            this.disabledValue = disabledValue;
            this.disabledOptionalValue = disabledOptionalValue;
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ENGLISH);
        }

        public String getDisabledValue() {
            return this.disabledValue;
        }

        public boolean hasDisableValue() {
            return this.hasDisableValue;
        }

        public String getDisabledOptionalValue() {
            return this.disabledOptionalValue;
        }

        public boolean hasDisableOptionalValue() {
            return this.disabledOptionalValue != null;
        }
    }
}

