/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterNameIF;
import java.util.List;

public class UserSequence
implements CmdClazzParameter {
    private CmdClazzParameterNameIF clazzParameterName = null;
    private Sequence sequence = null;

    public UserSequence() {
        this.sequence = Sequence.DDLOG_SEQ;
    }

    public UserSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public boolean exists(JdbcConnection connection, DatabaseSqlUser sqlUser) {
        boolean exists = false;
        String sequenceString = this.sequence.toString();
        connection.setConnectUser(sqlUser);
        List<String> result = connection.executeSQLCommand("SELECT SEQUENCE_NAME FROM SEQUENCES WHERE SCHEMA_NAME = CURRENT_USER");
        for (String resultString : result) {
            if (!sequenceString.equalsIgnoreCase(resultString)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public void createNewSequence(JdbcConnection connection, DatabaseSqlUser sqlUser) {
        connection.setConnectUser(sqlUser);
        connection.executeSQLCommandNoReslt("CREATE SEQUENCE DDLOG_SEQ CACHE 500 MINVALUE -2147483640 MAXVALUE 2147483640 INCREMENT BY 1");
    }

    public void dropSequence(JdbcConnection connection, DatabaseSqlUser sqlUser) {
        if (this.exists(connection, sqlUser)) {
            connection.executeSQLCommand("DROP SEQUENCE " + this.sequence.toString());
        }
    }

    @Override
    public String getValue() {
        return this.sequence.toString();
    }

    @Override
    public CmdClazzParameterNameIF getCmdClazzParameterName() {
        return this.clazzParameterName;
    }

    @Override
    public void setCmdClazzParameterName(CmdClazzParameterNameIF name) {
        this.clazzParameterName = name;
    }

    public static enum Sequence {
        DDLOG_SEQ;

    }
}

