/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user.password;

import com.sap.hdb.sl.lib.user.password.HdbPassword;
import com.sap.hdb.sl.lib.user.password.PasswordCheck;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterNameIF;

public class DatabaseSqlUserPassword
extends HdbPassword
implements CmdClazzParameter {
    private CmdClazzParameterNameIF name = null;

    protected DatabaseSqlUserPassword(String password) {
        super(password);
    }

    public DatabaseSqlUserPassword(CmdClazzParameterMap parameters) {
        super(parameters, CmdClazzParameterName.DATABASE_SQL_USER_PASSWORD);
    }

    @Override
    protected void createDefaultPasswordCheck() {
        this.passwordCheck.addRule(PasswordCheck.Rule.IS_NOT_NULL_OR_EMPTY);
        this.passwordCheck.addRule(PasswordCheck.Rule.CONTAINS_NO_BLANKS);
        this.passwordCheck.addRule(PasswordCheck.Rule.HAS_UPPER_CHARACTERS);
        this.passwordCheck.addRule(PasswordCheck.Rule.HAS_NUMBER);
        PasswordCheck.Rule length = PasswordCheck.Rule.HAS_MINIMUM_LENGTH;
        length.set(String.valueOf(8));
        this.passwordCheck.addRule(length);
    }

    @Override
    public String getValue() {
        return this.get();
    }

    @Override
    public CmdClazzParameterNameIF getCmdClazzParameterName() {
        return this.name;
    }

    @Override
    public void setCmdClazzParameterName(CmdClazzParameterNameIF name) {
        this.name = name;
    }

    @Override
    public boolean isValid() {
        return this.passwordCheck.isValid(this.password);
    }

    public String toString() {
        return this.password;
    }
}

