/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user.password;

import com.sap.hdb.sl.lib.user.password.HdbPassword;
import com.sap.hdb.sl.lib.user.password.PasswordCheck;
import com.sap.hdb.sl.lib.utils.HdbInstOption;
import com.sap.hdb.sl.lib.utils.InstallationParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterNameIF;

public class DatabaseSystemUserPassword
extends HdbPassword
implements InstallationParameter,
CmdClazzParameter {
    private CmdClazzParameterNameIF name = null;

    protected DatabaseSystemUserPassword(String password) {
        super(password);
    }

    public DatabaseSystemUserPassword(CmdClazzParameterMap parameters) {
        super(parameters, CmdClazzParameterName.DATABASE_SYSTEM_USER_PASSWORD);
    }

    @Override
    protected void createDefaultPasswordCheck() {
        this.passwordCheck.addRule(PasswordCheck.Rule.IS_NOT_NULL_OR_EMPTY);
        this.passwordCheck.addRule(PasswordCheck.Rule.CONTAINS_NO_BLANKS);
    }

    @Override
    public HdbInstOption getHdbInstOption() {
        return HdbInstOption.SYSTEM_USER_PASSWORD;
    }

    @Override
    public String getValue() {
        return this.get();
    }

    @Override
    public boolean isValid() {
        return this.passwordCheck.isValid(this.password);
    }

    @Override
    public boolean isValid(CmdClazzParameterMap parameters) {
        return super.isValid(parameters) || "manager".equals(this.password);
    }

    @Override
    public CmdClazzParameterNameIF getCmdClazzParameterName() {
        return this.name;
    }

    @Override
    public void setCmdClazzParameterName(CmdClazzParameterNameIF name) {
        this.name = name;
    }
}

