/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user.password;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.name.DatabaseSystemUserName;
import com.sap.hdb.sl.lib.user.password.DatabaseSystemUserPassword;
import com.sap.hdb.sl.lib.user.password.Password;
import com.sap.hdb.sl.lib.user.password.PasswordCheck;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterNameIF;

public abstract class HdbPassword
implements Password {
    protected String password = null;
    protected PasswordCheck passwordCheck = null;

    protected HdbPassword(String password) {
        this.password = password;
        this.createInitialPasswordCheck();
        this.createDefaultPasswordCheck();
    }

    protected HdbPassword(CmdClazzParameterMap parameters, CmdClazzParameterNameIF passwordKey) {
        this.password = parameters.get(passwordKey).getValue();
        if (this.setPolicyCheckFromDB(parameters.get(CmdClazzParameterName.HDB_CMD_CLAZZ_NAME).getValue())) {
            if (parameters.containsKey(CmdClazzParameterName.DATABASE_SYSTEM_USER_PASSWORD)) {
                try {
                    this.createPasswordCheckFromParameters(parameters);
                }
                catch (HdbException e) {
                    LogFactory.writeLogEntry(HdbPassword.class, "Error retrieving password policy from database: " + e.getMessage() + ". Using default values.");
                    this.createInitialPasswordCheck();
                    this.createDefaultPasswordCheck();
                }
            } else {
                this.createInitialPasswordCheck();
                this.createDefaultPasswordCheck();
            }
        }
    }

    private boolean setPolicyCheckFromDB(String clazzName) {
        String[] skipPolicyCheckFor = new String[]{"IS_CONNECT_POSSIBLE", "EXECUTE_SQL_GET_VALUE", "CHECK_SYSTEM_USER", "BACKUP_ARCHIVES"};
        for (int i = 0; i < skipPolicyCheckFor.length; ++i) {
            if (!clazzName.equals(skipPolicyCheckFor[i])) continue;
            return false;
        }
        return true;
    }

    protected void createDefaultPasswordCheck() {
    }

    private void createInitialPasswordCheck() {
        this.passwordCheck = new PasswordCheck();
        this.passwordCheck.addRule(PasswordCheck.Rule.IS_NOT_NULL_OR_EMPTY);
        this.passwordCheck.addRule(PasswordCheck.Rule.CONTAINS_NO_BLANKS);
    }

    private void createPasswordCheckFromParameters(CmdClazzParameterMap parameters) throws HdbException {
        Database database = InstanceFactory.getDatabaseInstance(parameters);
        DatabaseSystemUserPassword systemUserPassword = parameters.containsKey(CmdClazzParameterName.DATABASE_SID) && new Sid(parameters).isSystemDB() ? new DatabaseSystemUserPassword(parameters.get(CmdClazzParameterName.SYSTEM_DATABASE_SYSTEM_USER_PASSWORD).getValue()) : new DatabaseSystemUserPassword(parameters.get(CmdClazzParameterName.DATABASE_SYSTEM_USER_PASSWORD).getValue());
        DatabaseSystemUser systemUser = DatabaseSystemUserFactory.getUser(systemUserPassword);
        if (parameters.containsKey(CmdClazzParameterName.DATABASE_SYSTEM_USER_NAME)) {
            systemUser.setName(new DatabaseSystemUserName(parameters.get(CmdClazzParameterName.DATABASE_SYSTEM_USER_NAME).getValue()));
        }
        JdbcDriver jdbcDriver = new JdbcDriver(parameters);
        JdbcConnection connection = JdbcConnectionFactory.getInstance(jdbcDriver, database);
        DatabaseSqlUser sqlUser = null;
        boolean userPolicyCheck = false;
        if (parameters.containsKey(CmdClazzParameterName.DATABASE_SQL_USER_NAME)) {
            sqlUser = DatabaseSqlUserFactory.getUser(parameters);
            userPolicyCheck = sqlUser.exists(connection, systemUser) && connection.supports_M_EFFECTIVE_PASSWORD_POLICY();
        }
        DatabaseConfiguration indexServerConfig = new DatabaseConfiguration(connection, systemUser, DatabaseConfiguration.ConfigFileName.INDEXSERVER_INI);
        DatabaseConfigurationSection passwordPolicySection = indexServerConfig.getSection("password policy");
        this.passwordCheck = new PasswordCheck();
        String passwordMinLength = userPolicyCheck ? sqlUser.getUserGroupPolicyValue(connection, "minimal_password_length") : passwordPolicySection.getParameterValue("minimal_password_length");
        PasswordCheck.Rule.HAS_MINIMUM_LENGTH.set(passwordMinLength);
        this.passwordCheck.addRule(PasswordCheck.Rule.HAS_MINIMUM_LENGTH);
        this.passwordCheck.addRule(PasswordCheck.Rule.IS_NOT_NULL_OR_EMPTY);
        String passwordLayout = userPolicyCheck ? sqlUser.getUserGroupPolicyValue(connection, "password_layout") : passwordPolicySection.getParameterValue("password_layout");
        LogFactory.writeLogEntry(HdbPassword.class, "Configured password_layout is: " + passwordLayout + ", minimum password length: " + passwordMinLength);
        int digitsNumber = 0;
        int upperCaseNumber = 0;
        int lowerCaseNumber = 0;
        int specialCharacterNumber = 0;
        for (char character : passwordLayout.toCharArray()) {
            if (Character.isDigit(character)) {
                ++digitsNumber;
                continue;
            }
            if (Character.isUpperCase(character)) {
                ++upperCaseNumber;
                continue;
            }
            if (Character.isLowerCase(character)) {
                ++lowerCaseNumber;
                continue;
            }
            ++specialCharacterNumber;
        }
        if (digitsNumber > 0) {
            PasswordCheck.Rule.HAS_NUMBER.set(Integer.toString(digitsNumber));
            this.passwordCheck.addRule(PasswordCheck.Rule.HAS_NUMBER);
        }
        if (upperCaseNumber > 0) {
            PasswordCheck.Rule.HAS_UPPER_CHARACTERS.set(Integer.toString(upperCaseNumber));
            this.passwordCheck.addRule(PasswordCheck.Rule.HAS_UPPER_CHARACTERS);
        }
        if (lowerCaseNumber > 0) {
            PasswordCheck.Rule.HAS_LOWER_CHARACTERS.set(Integer.toString(lowerCaseNumber));
            this.passwordCheck.addRule(PasswordCheck.Rule.HAS_LOWER_CHARACTERS);
        }
        if (specialCharacterNumber > 0) {
            PasswordCheck.Rule.HAS_SPECIAL_CHARACTERS.set(Integer.toString(specialCharacterNumber));
            this.passwordCheck.addRule(PasswordCheck.Rule.HAS_SPECIAL_CHARACTERS);
        }
    }

    @Override
    public String get() {
        return this.password;
    }

    @Override
    public boolean isValid() {
        return this.passwordCheck.isValid(this.password);
    }

    public boolean isValid(CmdClazzParameterMap parameters) {
        try {
            this.createPasswordCheckFromParameters(parameters);
        }
        catch (HdbException e) {
            LogFactory.writeLogEntry(HdbPassword.class, "Error retrieving password policy from database: " + e.getMessage() + ". Using default values.");
        }
        return this.passwordCheck.isValid(this.password);
    }

    @Override
    public String getRuleDescription() {
        return this.passwordCheck.getComplexityDescription();
    }
}

