/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user.password;

import com.sap.hdb.sl.lib.user.password.PasswordRuleDescription;
import java.util.ArrayList;
import java.util.List;

public class PasswordCheck {
    private List<Rule> rules = new ArrayList<Rule>();
    private PasswordRuleDescription ruleDescription = new PasswordRuleDescription();

    public boolean isValid(String password) {
        for (Rule rule : this.rules) {
            if (rule.doCheck(password)) continue;
            return false;
        }
        return true;
    }

    public void addRule(Rule rule) {
        if (!this.rules.contains((Object)rule)) {
            this.ruleDescription.addDescription(rule.getDescription());
            this.rules.add(rule);
        }
    }

    public String getComplexityDescription() {
        return this.ruleDescription.get();
    }

    public static boolean isNotNullOrEmpty(String password) {
        return null != password && password.length() > 0;
    }

    public static boolean containsNoBlanks(String password) {
        return null != password && !password.contains(" ");
    }

    public static boolean hasMinimumLength(String password, int length) {
        return null != password && password.length() >= length;
    }

    public static boolean hasUpperCharacters(String password, int amount) {
        if (null != password) {
            char[] characters;
            int found = 0;
            for (char character : characters = password.toCharArray()) {
                if (!Character.isUpperCase(character)) continue;
                ++found;
            }
            if (found >= amount) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasLowerCharacters(String password, int amount) {
        if (null != password) {
            char[] characters;
            int found = 0;
            for (char character : characters = password.toCharArray()) {
                if (!Character.isLowerCase(character)) continue;
                ++found;
            }
            if (found >= amount) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasNumbers(String password, int amount) {
        if (null != password) {
            char[] characters;
            int found = 0;
            for (char character : characters = password.toCharArray()) {
                String s = String.valueOf(character);
                if (!s.matches("[0-9]")) continue;
                ++found;
            }
            if (found >= amount) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasSpecialCharacters(String password, int amount) {
        if (null != password) {
            char[] characters;
            int found = 0;
            for (char character : characters = password.toCharArray()) {
                if (Character.isLetterOrDigit(character)) continue;
                ++found;
            }
            if (found >= amount) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasNoForbiddenCharacters(String password, char[] allowedCharacters) {
        boolean hasForbiddenCharacters = false;
        for (char singleChar : password.toCharArray()) {
            String singleString = String.valueOf(singleChar);
            if (singleString.matches("[0-9]") || singleString.matches("[a-z]") || singleString.matches("[A-Z]")) continue;
            hasForbiddenCharacters = true;
            for (char allowedChar : allowedCharacters) {
                if (allowedChar != singleChar) continue;
                hasForbiddenCharacters = false;
                break;
            }
            if (hasForbiddenCharacters) break;
        }
        return !hasForbiddenCharacters;
    }

    public static enum Rule {
        IS_NOT_NULL_OR_EMPTY{

            @Override
            public boolean doCheck(String password) {
                return PasswordCheck.isNotNullOrEmpty(password);
            }

            @Override
            public String getDescription() {
                return "must not be null or empty";
            }

            @Override
            public void set(String string) {
            }
        }
        ,
        CONTAINS_NO_BLANKS{

            @Override
            public boolean doCheck(String password) {
                return PasswordCheck.containsNoBlanks(password);
            }

            @Override
            public String getDescription() {
                return "must not contain blanks";
            }

            @Override
            public void set(String string) {
            }
        }
        ,
        HAS_UPPER_CHARACTERS{
            private int amount = 1;

            @Override
            public void set(String amount) {
                this.amount = Integer.parseInt(amount);
            }

            @Override
            public boolean doCheck(String password) {
                return PasswordCheck.hasUpperCharacters(password, this.amount);
            }

            @Override
            public String getDescription() {
                return "must contain at least " + this.amount + " upper-case character" + (this.amount > 1 ? "s" : "");
            }
        }
        ,
        HAS_LOWER_CHARACTERS{
            private int amount = 1;

            @Override
            public void set(String amount) {
                this.amount = Integer.parseInt(amount);
            }

            @Override
            public boolean doCheck(String password) {
                return PasswordCheck.hasLowerCharacters(password, this.amount);
            }

            @Override
            public String getDescription() {
                return "must contain at least " + this.amount + " lower-case character" + (this.amount > 1 ? "s" : "");
            }
        }
        ,
        HAS_MINIMUM_LENGTH{
            private int length = 1;

            @Override
            public boolean doCheck(String password) {
                return PasswordCheck.hasMinimumLength(password, this.length);
            }

            @Override
            public String getDescription() {
                return "minimum length is " + this.length;
            }

            @Override
            public void set(String length) {
                this.length = Integer.parseInt(length);
            }
        }
        ,
        HAS_NUMBER{
            private int amount = 1;

            @Override
            public boolean doCheck(String password) {
                return PasswordCheck.hasNumbers(password, this.amount);
            }

            @Override
            public String getDescription() {
                return "must contain at least " + this.amount + " number" + (this.amount > 1 ? "s" : "");
            }

            @Override
            public void set(String amount) {
                this.amount = Integer.parseInt(amount);
            }
        }
        ,
        HAS_SPECIAL_CHARACTERS{
            private int amount = 1;

            @Override
            public boolean doCheck(String password) {
                return PasswordCheck.hasSpecialCharacters(password, this.amount);
            }

            @Override
            public String getDescription() {
                return "must contain at least " + this.amount + " special character" + (this.amount > 1 ? "s" : "");
            }

            @Override
            public void set(String amount) {
                this.amount = Integer.parseInt(amount);
            }
        }
        ,
        HAS_NO_FORBIDDEN_CHARACTERS{
            private char[] specialChars = "".toCharArray();

            @Override
            public boolean doCheck(String password) {
                return PasswordCheck.hasNoForbiddenCharacters(password, this.specialChars);
            }

            @Override
            public String getDescription() {
                if (this.specialChars.length == 0) {
                    return "can only contain numbers and letters";
                }
                return "can only contain numbers, letters, and the following special characters: " + String.valueOf(this.specialChars);
            }

            @Override
            public void set(String specialCharacters) {
                this.specialChars = specialCharacters.toCharArray();
            }
        };


        public abstract boolean doCheck(String var1);

        public abstract String getDescription();

        public abstract void set(String var1);
    }
}

