/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user.password;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.PasswordPolicy;
import com.sap.hdb.sl.lib.user.password.DatabaseSqlUserPassword;
import com.sap.hdb.sl.lib.user.password.DatabaseSystemUserPassword;
import com.sap.hdb.sl.lib.user.password.OperatingSystemUserPassword;
import com.sap.hdb.sl.lib.user.password.Password;
import com.sap.hdb.sl.lib.user.password.PasswordCheckResult;
import com.sap.hdb.sl.lib.user.password.PasswordImpl;
import com.sap.hdb.sl.lib.user.password.SapHostAgentUserPassword;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Random;

public class PasswordFactory {
    private static ArrayList<Password> PASSWORDS = new ArrayList();
    private static int passwordLength = 8;
    private static boolean passLengthRead = false;
    private static String passwordLayout = "";
    private static boolean passwordLayoutRead = false;

    public static ArrayList<Password> getPasswords() {
        return PASSWORDS;
    }

    public static DatabaseSqlUserPassword getDatabaseSqlUserPassword(String password) {
        DatabaseSqlUserPassword pwd = new DatabaseSqlUserPassword(password);
        PASSWORDS.add(pwd);
        return pwd;
    }

    public static DatabaseSqlUserPassword generatePassword(JdbcConnection connection, DatabaseSystemUser systemUser) {
        int numTries;
        String password = PasswordFactory.generatePasswordByPasswordLayout(connection, systemUser);
        for (numTries = 0; PasswordFactory.validatePasswordViaProc(connection, password).getErrorCode() != 0 && numTries < 20; ++numTries) {
            password = PasswordFactory.shufflePassword(password);
        }
        if (numTries == 20) {
            throw new HdbException("Could not generate password that is not in the exclude list.");
        }
        DatabaseSqlUserPassword pwd = new DatabaseSqlUserPassword(password);
        PASSWORDS.add(pwd);
        return pwd;
    }

    private static String generatePasswordByPasswordLayout(JdbcConnection connection, DatabaseSystemUser systemUser) {
        if (!passLengthRead) {
            int pass_length_set_in_db = 0;
            String tenantMinLength = PasswordPolicy.getParameterValue(connection, systemUser, "minimal_password_length");
            String systemDbMinLength = "0";
            if (connection.isConnectedToSystemDB()) {
                systemDbMinLength = PasswordPolicy.getSystemDbParameterValue(connection, systemUser, "minimal_password_length");
            }
            if ((pass_length_set_in_db = Math.max(Integer.parseInt(tenantMinLength), Integer.parseInt(systemDbMinLength))) > 8) {
                passwordLength = pass_length_set_in_db;
            }
            LogFactory.writeLogEntry(PasswordFactory.class, "Minimal used password length is: " + passwordLength);
            passLengthRead = true;
        }
        if (!passwordLayoutRead) {
            passwordLayout = PasswordPolicy.getParameterValue(connection, systemUser, "password_layout");
            if (connection.isConnectedToSystemDB()) {
                passwordLayout = PasswordPolicy.getSystemDbParameterValue(connection, systemUser, "password_layout");
            }
            LogFactory.writeLogEntry(PasswordFactory.class, "Used password layout is: " + passwordLayout);
            passwordLayoutRead = true;
        }
        Random rand = new Random();
        StringBuffer sb = new StringBuffer();
        String upperCase = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String lowerCase = "abcdefghijklmnopqrstuvwxyz";
        String digits = "0123456789";
        for (int i = 0; i < passwordLayout.length(); ++i) {
            String chr = passwordLayout.substring(i, i + 1);
            if (upperCase.indexOf(chr) > -1) {
                sb.append(upperCase.charAt(rand.nextInt(26)));
                continue;
            }
            if (lowerCase.indexOf(chr) > -1) {
                sb.append(lowerCase.charAt(rand.nextInt(26)));
                continue;
            }
            if (digits.indexOf(chr) > -1) {
                sb.append(digits.charAt(rand.nextInt(10)));
                continue;
            }
            sb.append('_');
        }
        for (int j = sb.length(); j < passwordLength; ++j) {
            if (j % 3 == 0) {
                sb.append(upperCase.charAt(rand.nextInt(26)));
                continue;
            }
            if (j % 3 == 1) {
                sb.append(lowerCase.charAt(rand.nextInt(26)));
                continue;
            }
            sb.append(digits.charAt(rand.nextInt(10)));
        }
        String password = sb.toString();
        return password;
    }

    private static String shufflePassword(String password) {
        StringBuffer sbPassword = new StringBuffer(password);
        StringBuffer sbShuffledPassword = new StringBuffer();
        Random rand = new Random();
        while (sbPassword.length() != 0) {
            int index = rand.nextInt(sbPassword.length());
            char c = sbPassword.charAt(index);
            sbPassword.deleteCharAt(index);
            sbShuffledPassword.append(c);
        }
        String shuffledPassword = sbShuffledPassword.toString();
        return shuffledPassword;
    }

    private static PasswordCheckResult validatePasswordViaProc(JdbcConnection connection, String password) {
        try {
            PasswordCheckResult result = null;
            CallableStatement cs = connection.getConnection().prepareCall("{call SYS.IS_VALID_PASSWORD(?, ?, ?)}");
            cs.setString(1, password);
            cs.registerOutParameter(2, 4);
            cs.registerOutParameter(3, -9);
            cs.execute();
            result = new PasswordCheckResult(cs.getInt(2), cs.getString(3));
            return result;
        }
        catch (SQLException e1) {
            return new PasswordCheckResult(-1, "An exception occurred during the call of procedure SYS.IS_VALID_PASSWORD!");
        }
    }

    public static DatabaseSystemUserPassword getDatabaseSystemUserPassword(String password) {
        DatabaseSystemUserPassword pwd = new DatabaseSystemUserPassword(password);
        PASSWORDS.add(pwd);
        return pwd;
    }

    public static DatabaseSystemUserPassword getDatabaseSystemUserNewPassword(CmdClazzParameterMap parameters) {
        DatabaseSystemUserPassword pwd = new DatabaseSystemUserPassword(parameters.get(CmdClazzParameterName.DATABASE_SYSTEM_USER_NEW_PASSWORD).getValue());
        PASSWORDS.add(pwd);
        return pwd;
    }

    public static OperatingSystemUserPassword getOperatingSystemUserPassword(String password) {
        OperatingSystemUserPassword pwd = new OperatingSystemUserPassword(password);
        PASSWORDS.add(pwd);
        return pwd;
    }

    public static DatabaseSqlUserPassword getDatabaseSqlUserPassword(CmdClazzParameterMap parameters) {
        DatabaseSqlUserPassword pwd = new DatabaseSqlUserPassword(parameters);
        PASSWORDS.add(pwd);
        return pwd;
    }

    public static SapHostAgentUserPassword getSapHostAgentUserPassword(String password) {
        SapHostAgentUserPassword pwd = new SapHostAgentUserPassword(password);
        PASSWORDS.add(pwd);
        return pwd;
    }

    public static void addGenericPassword(String password) {
        PASSWORDS.add(new PasswordImpl(password));
    }
}

