/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user.role;

import com.sap.hdb.sl.lib.connection.sql.HdbConnection;
import com.sap.hdb.sl.lib.connection.sql.HdbsqlConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Privilege;
import com.sap.hdb.sl.lib.user.DatabaseHdbsqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRole;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleName;
import com.sap.hdb.sl.lib.user.role.MissingPrivileges;
import java.util.List;

public class AbapAdminRole
implements DatabaseUserRole {
    private DatabaseUserRoleName name;
    private String nameString;

    protected AbapAdminRole(DatabaseUserRoleName name) {
        this.name = name;
        this.nameString = name.toString();
    }

    @Override
    public void createNewRole(JdbcConnection connection, DatabaseUser createUser, DatabaseUser grantUser) {
        connection.setConnectUser(createUser);
        if (!this.exists(connection, createUser)) {
            connection.executeSQLCommandNoReslt("CREATE ROLE " + this.nameString);
        }
        connection.setConnectUser(grantUser);
        try {
            connection.executeSQLCommandNoReslt("GRANT ROLE ADMIN, USER ADMIN, CATALOG READ TO " + this.nameString);
            connection.executeSQLCommandNoReslt("GRANT " + Privilege.EXECUTE.toString() + " ON \"_SYS_REPO\".\"GRANT_ACTIVATED_ROLE\" TO " + this.nameString);
            connection.executeSQLCommandNoReslt("GRANT " + Privilege.EXECUTE.toString() + " ON \"_SYS_REPO\".\"REVOKE_ACTIVATED_ROLE\" TO " + this.nameString);
        }
        catch (HdbException e) {
            this.dropRole(connection, createUser);
            throw e;
        }
    }

    @Override
    public void createNewRole(JdbcConnection connection, DatabaseUser user) {
        this.createNewRole(connection, user, user);
    }

    @Override
    public void dropRole(JdbcConnection connection, DatabaseUser systemUser) {
        if (this.exists(connection, systemUser)) {
            connection.executeSQLCommand("DROP ROLE " + this.nameString);
        }
    }

    @Override
    public boolean exists(JdbcConnection connection, DatabaseUser user) {
        List<String> result = this.executeStatement("SELECT ROLE_NAME FROM ROLES", connection, user);
        for (String resultString : result) {
            if (!this.nameString.equalsIgnoreCase(resultString)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addSqlPrivileges(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser) {
        HdbConnection slConnection;
        if (this.exists(connection, systemUser)) {
            slConnection = null;
            if (sqlUser.useJdbc()) {
                slConnection = connection;
                slConnection.setConnectUser(sqlUser);
            } else {
                slConnection = new HdbsqlConnection();
                DatabaseHdbsqlUser hdbSqlUser = (DatabaseHdbsqlUser)sqlUser;
                slConnection.setConnectUser(hdbSqlUser);
            }
        } else {
            throw new HdbException(this.nameString + " role does not exist. Cannot grant necessary SQL privileges.");
        }
        slConnection.executeSQLCommand("GRANT " + Privilege.SELECT.toString() + " ON SCHEMA " + sqlUser.getName().get() + " TO " + this.nameString);
    }

    @Override
    public DatabaseUserRoleName getName() {
        return this.name;
    }

    @Override
    public void grantTo(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser) {
        connection.setConnectUser(systemUser);
        connection.executeSQLCommand("GRANT " + this.nameString + " TO " + sqlUser.getName().get());
    }

    private List<String> executeStatement(String statement, JdbcConnection connection, DatabaseUser user) {
        connection.setConnectUser(user);
        return connection.executeSQLCommand(statement);
    }

    @Override
    public MissingPrivileges checkPrivileges(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser) {
        return new MissingPrivileges(this);
    }
}

