/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user.role;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRole;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleName;
import com.sap.hdb.sl.lib.user.role.MissingPrivileges;
import com.sap.hdb.sl.lib.user.role.PrivilegesUtils;
import java.util.ArrayList;
import java.util.List;

public class AflSysAflLcAppsExecuteRole
implements DatabaseUserRole {
    private DatabaseUserRoleName name = null;
    private String nameString = null;
    String[][] objectPrivileges = new String[][]{{"LCAALERTS", "", "CREATE ANY"}, {"LCAALERTS", "", "DROP"}, {"LCAALERTS", "", "SELECT"}, {"LCAALERTS", "", "INSERT"}, {"LCAALERTS", "", "DELETE"}};

    protected AflSysAflLcAppsExecuteRole(DatabaseUserRoleName name) {
        this.name = name;
        this.nameString = name.toString();
    }

    @Override
    public void createNewRole(JdbcConnection connection, DatabaseUser createUser, DatabaseUser grantUser) {
        throw new HdbException(this.nameString + " Cannot create Role. Role is created by HANA automatically after LCAPPS Routines are installed.");
    }

    @Override
    public void createNewRole(JdbcConnection connection, DatabaseUser user) {
        this.createNewRole(connection, user, user);
    }

    @Override
    public void dropRole(JdbcConnection connection, DatabaseUser systemUser) {
        LogFactory.writeLogEntry(this.getClass(), this.nameString + ", Cannot drop System Role.");
    }

    @Override
    public boolean exists(JdbcConnection connection, DatabaseUser systemUser) {
        List<String> result = this.executeStatement("SELECT ROLE_NAME FROM ROLES", connection, systemUser);
        for (String resultString : result) {
            if (!this.nameString.equalsIgnoreCase(resultString)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addSqlPrivileges(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser) {
    }

    @Override
    public DatabaseUserRoleName getName() {
        return this.name;
    }

    @Override
    public void grantTo(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser) {
        connection.setConnectUser(systemUser);
        connection.executeSQLCommand("GRANT " + this.nameString + " TO " + sqlUser.getName().get());
    }

    private List<String> executeStatement(String statement, JdbcConnection connection, DatabaseUser systemUser) {
        connection.setConnectUser(systemUser);
        return connection.executeSQLCommand(statement);
    }

    @Override
    public MissingPrivileges checkPrivileges(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser) {
        MissingPrivileges missingPriv = new MissingPrivileges(this);
        connection.setConnectUser(systemUser);
        if (this.exists(connection, systemUser)) {
            ArrayList<String> missingRoles = new ArrayList<String>();
            if (!PrivilegesUtils.checkRole(connection, this.getName().get(), sqlUser.getName().get())) {
                missingRoles.add(this.getName().get());
                missingPriv.addMissingRoles(missingRoles);
            }
            ArrayList<String> missingObjectPrivileges = PrivilegesUtils.checkObjectPrivileges(connection, systemUser, sqlUser, this.objectPrivileges, sqlUser.getName().get());
            missingPriv.addMissingObjectPrivileges(missingObjectPrivileges);
        }
        DatabaseSqlUser sysRepoUser = DatabaseSqlUserFactory.getUser(new DatabaseSqlUserName("_SYS_REPO"));
        missingPriv.addMissingPrivileges(PrivilegesUtils.checkRoleIfExist(connection, systemUser, sysRepoUser, this));
        return missingPriv;
    }

    public String[][] getObjectPrivileges() {
        return this.objectPrivileges;
    }
}

