/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user.role;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.user.role.AbapAdminRole;
import com.sap.hdb.sl.lib.user.role.AbapDevRole;
import com.sap.hdb.sl.lib.user.role.AbapReadRole;
import com.sap.hdb.sl.lib.user.role.AbapSysRepoRole;
import com.sap.hdb.sl.lib.user.role.AflSysAflAflbflExecute;
import com.sap.hdb.sl.lib.user.role.AflSysAflAflpalExecute;
import com.sap.hdb.sl.lib.user.role.AflSysAflErpaExecute;
import com.sap.hdb.sl.lib.user.role.AflSysAflLcAppsExecuteRole;
import com.sap.hdb.sl.lib.user.role.AflSysAflPosdmAreaExecute;
import com.sap.hdb.sl.lib.user.role.AflSysAflSopAreaExecute;
import com.sap.hdb.sl.lib.user.role.AflSysAflUdfcoreAreaExecute;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRole;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleName;
import com.sap.hdb.sl.lib.user.role.DbaCockPitRole;
import com.sap.hdb.sl.lib.user.role.TableRedistributionRole;
import com.sap.hdb.sl.lib.user.role.UserRole;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;

public class DatabaseUserRoleFactory {
    public static DatabaseUserRole getNewRole(DatabaseUserRoleName.Role role) {
        return DatabaseUserRoleFactory.getNewRole(new DatabaseUserRoleName(role));
    }

    public static DatabaseUserRole getNewRole(DatabaseUserRoleName roleName) {
        DatabaseUserRoleName.Role role = roleName.getRole();
        DatabaseUserRole databaseUserRole = null;
        switch (role) {
            case DBA_COCKPIT: {
                databaseUserRole = new DbaCockPitRole(roleName);
                break;
            }
            case USER: {
                databaseUserRole = new UserRole(roleName);
                break;
            }
            case ABAP_ADMIN: {
                databaseUserRole = new AbapAdminRole(roleName);
                break;
            }
            case ABAP_DEV: {
                databaseUserRole = new AbapDevRole(roleName);
                break;
            }
            case ABAP_READ: {
                databaseUserRole = new AbapReadRole(roleName);
                break;
            }
            case ABAP_SYS_REPO: {
                databaseUserRole = new AbapSysRepoRole(roleName);
                break;
            }
            case AFL__SYS_AFL_LCAPPS_EXECUTE: {
                databaseUserRole = new AflSysAflLcAppsExecuteRole(roleName);
                break;
            }
            case AFL__SYS_AFL_ERPA_EXECUTE: {
                databaseUserRole = new AflSysAflErpaExecute(roleName);
                break;
            }
            case AFL__SYS_AFL_AFLBFL_EXECUTE: {
                databaseUserRole = new AflSysAflAflbflExecute(roleName);
                break;
            }
            case AFL__SYS_AFL_AFLPAL_EXECUTE: {
                databaseUserRole = new AflSysAflAflpalExecute(roleName);
                break;
            }
            case AFL__SYS_AFL_POSDM_AREA_EXECUTE: {
                databaseUserRole = new AflSysAflPosdmAreaExecute(roleName);
                break;
            }
            case AFL__SYS_AFL_SOP_AREA_EXECUTE: {
                databaseUserRole = new AflSysAflSopAreaExecute(roleName);
                break;
            }
            case AFL__SYS_AFL_UDFCORE_AREA_EXECUTE: {
                databaseUserRole = new AflSysAflUdfcoreAreaExecute(roleName);
                break;
            }
            case TABLE_REDISTRIBUTION: {
                databaseUserRole = new TableRedistributionRole(roleName);
                break;
            }
            default: {
                throw new HdbException(roleName + " Not a valid roleName!");
            }
        }
        return databaseUserRole;
    }

    public static DatabaseUserRole getNewRole(CmdClazzParameterMap parameters) {
        DatabaseUserRoleName roleName = (DatabaseUserRoleName)parameters.get(CmdClazzParameterName.DATABASE_USER_ROLE);
        return DatabaseUserRoleFactory.getNewRole(roleName);
    }
}

