/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user.role;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterNameIF;
import java.util.Locale;

public class DatabaseUserRoleName
implements CmdClazzParameter {
    private CmdClazzParameterNameIF clazzParameterName = null;
    private Role role = null;

    public DatabaseUserRoleName(Role userRole) {
        this.role = userRole;
    }

    public DatabaseUserRoleName(String userRole) {
        try {
            this.role = Role.valueOf(userRole.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new HdbException(userRole + " No such Role! " + e.getMessage());
        }
    }

    public Role getRole() {
        return this.role;
    }

    public String get() {
        return this.role.toString();
    }

    @Override
    public String getValue() {
        return this.role.toString();
    }

    @Override
    public CmdClazzParameterNameIF getCmdClazzParameterName() {
        return this.clazzParameterName;
    }

    @Override
    public void setCmdClazzParameterName(CmdClazzParameterNameIF name) {
        this.clazzParameterName = name;
    }

    public String toString() {
        return this.getValue();
    }

    public static enum Role {
        USER,
        DBA_COCKPIT,
        ABAP_SYS_REPO,
        ABAP_ADMIN,
        ABAP_DEV,
        ABAP_READ,
        AFL__SYS_AFL_LCAPPS_EXECUTE,
        AFL__SYS_AFL_ERPA_EXECUTE,
        AFL__SYS_AFL_AFLBFL_EXECUTE,
        AFL__SYS_AFL_AFLPAL_EXECUTE,
        AFL__SYS_AFL_POSDM_AREA_EXECUTE,
        AFL__SYS_AFL_SOP_AREA_EXECUTE,
        AFL__SYS_AFL_UDFCORE_AREA_EXECUTE,
        TABLE_REDISTRIBUTION;

    }
}

