/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user.role;

import com.sap.hdb.sl.lib.abap.BasisUtils;
import com.sap.hdb.sl.lib.connection.sql.HdbConnection;
import com.sap.hdb.sl.lib.connection.sql.HdbsqlConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseStatisticsServer;
import com.sap.hdb.sl.lib.instance.Privilege;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseHdbsqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRole;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleName;
import com.sap.hdb.sl.lib.user.role.MissingPrivileges;
import com.sap.hdb.sl.lib.user.role.PrivilegeObject;
import com.sap.hdb.sl.lib.user.role.PrivilegesUtils;
import java.util.ArrayList;
import java.util.List;

public class DbaCockPitRole
implements DatabaseUserRole {
    DatabaseUserRoleName name = null;
    String nameString = null;
    String[] roles = new String[]{"MONITORING"};
    String[] systemPrivileges = new String[]{"BACKUP ADMIN", "CATALOG READ", "INIFILE ADMIN", "SERVICE ADMIN", "TRACE ADMIN", "RESOURCE ADMIN", "LICENSE ADMIN"};
    String[][] objectPrivileges = new String[][]{{"SYS", "MANAGEMENT_CONSOLE_PROC", "EXECUTE"}};

    protected DbaCockPitRole(DatabaseUserRoleName name) {
        this.name = name;
        this.nameString = name.toString();
    }

    @Override
    public boolean exists(JdbcConnection connection, DatabaseUser systemUser) {
        boolean exists = false;
        List<String> result = this.executeStatement("SELECT ROLE_NAME FROM ROLES", connection, systemUser);
        for (String resultString : result) {
            if (!this.nameString.equalsIgnoreCase(resultString)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    @Override
    public void createNewRole(JdbcConnection connection, DatabaseUser connectUser, DatabaseUser grantUser) {
        Database database = connection.getDatabase();
        if (connection.getDbVersion() < 4 && !database.isStatisticsServerOnline(connection, grantUser)) {
            DatabaseStatisticsServer statServer = new DatabaseStatisticsServer();
            statServer.setOn(connection, DatabaseSystemUserFactory.getUser(PasswordFactory.getDatabaseSystemUserPassword(grantUser.getPassword().get())));
        }
        connection.setConnectUser(connectUser);
        if (!this.exists(connection, connectUser)) {
            connection.executeSQLCommandNoReslt("CREATE ROLE " + this.nameString);
        }
        connection.setConnectUser(grantUser);
        try {
            String[] dbaCockpitGrants = new String[]{"GRANT MONITORING TO " + this.nameString, "GRANT BACKUP ADMIN TO " + this.nameString, "GRANT CATALOG READ TO " + this.nameString, "GRANT INIFILE ADMIN TO " + this.nameString, "GRANT SERVICE ADMIN TO " + this.nameString, "GRANT TRACE ADMIN TO " + this.nameString, "GRANT RESOURCE ADMIN TO " + this.nameString, "GRANT EXECUTE ON SYS.MANAGEMENT_CONSOLE_PROC TO " + this.nameString};
            String[] dbaCockpitGrantsOnPremise = new String[]{"GRANT LICENSE ADMIN TO " + this.nameString};
            String[] dbaCockpitOptionalGrants = new String[]{"GRANT EXECUTE ON SYS.FULL_SYSTEM_INFO_DUMP_CREATE TO " + this.nameString, "GRANT EXECUTE ON SYS.FULL_SYSTEM_INFO_DUMP_RETRIEVE TO " + this.nameString, "GRANT EXECUTE ON SYS.FULL_SYSTEM_INFO_DUMP_DELETE TO " + this.nameString, "GRANT SELECT ON SYS.FULL_SYSTEM_INFO_DUMPS TO " + this.nameString};
            this.executeStatements(dbaCockpitGrants, connection, grantUser);
            if (connection.getDbVersion() < 4) {
                this.executeStatements(dbaCockpitGrantsOnPremise, connection, grantUser);
            }
            this.executeOptionalStatements(dbaCockpitOptionalGrants, connection, grantUser);
            if (connection.getDbVersion() < 4 && !database.isMultiDB(connection, connectUser)) {
                this.grantSysStat(connection, grantUser);
            }
        }
        catch (HdbException e) {
            this.dropRole(connection, connectUser);
            throw e;
        }
    }

    @Override
    public void createNewRole(JdbcConnection connection, DatabaseUser user) {
        this.createNewRole(connection, user, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantSysStat(JdbcConnection connection, DatabaseUser systemUser) {
        ArrayList<String> statements = new ArrayList<String>();
        statements.add("GRANT " + Privilege.SELECT.toString() + " ON SCHEMA _SYS_STATISTICS TO " + this.nameString);
        statements.add("GRANT " + Privilege.INSERT.toString() + " ON SCHEMA _SYS_STATISTICS TO " + this.nameString);
        statements.add("GRANT " + Privilege.UPDATE.toString() + " ON SCHEMA _SYS_STATISTICS TO " + this.nameString);
        statements.add("GRANT " + Privilege.DELETE.toString() + " ON SCHEMA _SYS_STATISTICS TO " + this.nameString);
        String[] optionalGrant = new String[]{"GRANT " + Privilege.EXECUTE.toString() + " ON SCHEMA _SYS_STATISTICS TO " + this.nameString};
        Database database = connection.getDatabase();
        int numberOfTries = 40;
        for (int tryNumber = 1; tryNumber < numberOfTries + 1; ++tryNumber) {
            DbaCockPitRole dbaCockPitRole;
            if (database.isStatisticsServerOnline(connection, systemUser)) {
                dbaCockPitRole = this;
                synchronized (dbaCockPitRole) {
                    LogFactory.writeLogEntry(this.getClass(), ((Object)statements).toString() + ". Statistics server is online. Wait for additional 10 seconds.");
                    try {
                        this.wait(10000L);
                    }
                    catch (InterruptedException e) {
                        throw new HdbException(e);
                    }
                }
                this.executeStatements(statements.toArray(new String[statements.size()]), connection, systemUser);
                this.executeOptionalStatements(optionalGrant, connection, systemUser);
                break;
            }
            if (tryNumber < numberOfTries) {
                dbaCockPitRole = this;
                synchronized (dbaCockPitRole) {
                    LogFactory.writeLogEntry(this.getClass(), ((Object)statements).toString() + ". Statistics server is not online yet. Wait for 10 seconds. " + tryNumber + " of " + numberOfTries + " tries.");
                    try {
                        this.wait(10000L);
                    }
                    catch (InterruptedException e) {
                        throw new HdbException(e);
                    }
                }
            }
            throw new HdbException("Statistics server is not online! Cannot grant necessary right: " + ((Object)statements).toString());
        }
    }

    @Override
    public void addSqlPrivileges(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser) {
        if (this.exists(connection, systemUser)) {
            String[] tables = new String[]{"SVERS", "CVERS"};
            HdbConnection slConnection = null;
            if (sqlUser.useJdbc()) {
                slConnection = connection;
                slConnection.setConnectUser(sqlUser);
            } else {
                slConnection = new HdbsqlConnection();
                DatabaseHdbsqlUser hdbSqlUser = (DatabaseHdbsqlUser)sqlUser;
                slConnection.setConnectUser(hdbSqlUser);
            }
            for (String table : tables) {
                if (!BasisUtils.tableExists(table, connection)) continue;
                slConnection.executeSQLCommand("GRANT " + Privilege.SELECT.toString() + " ON " + sqlUser.toString() + "." + table + " TO " + this.nameString);
            }
        } else {
            throw new HdbException(this.nameString + " role does not exist. Cannot grant necessary SQL privileges.");
        }
    }

    @Override
    public void dropRole(JdbcConnection connection, DatabaseUser systemUser) {
        if (this.exists(connection, systemUser)) {
            connection.executeSQLCommand("DROP ROLE " + this.nameString);
        }
    }

    private List<String> executeStatement(String statement, JdbcConnection connection, DatabaseUser systemUser) {
        connection.setConnectUser(systemUser);
        return connection.executeSQLCommand(statement);
    }

    private void executeStatements(String[] statements, JdbcConnection connection, DatabaseUser systemUser) {
        for (String statement : statements) {
            this.executeStatement(statement, connection, systemUser);
        }
    }

    private void executeOptionalStatements(String[] statements, JdbcConnection connection, DatabaseUser systemUser) {
        for (String statement : statements) {
            try {
                this.executeStatement(statement, connection, systemUser);
            }
            catch (HdbException e) {
                if (connection.getErrorCode() == 397) {
                    LogFactory.writeLogEntry(this.getClass(), "Unable to execute optional statement '" + statement + "': Object doesn't exist.");
                    continue;
                }
                LogFactory.writeLogEntry(this.getClass(), "Unable to execute optional statement '" + statement + "': " + e.getMessage());
            }
        }
    }

    @Override
    public DatabaseUserRoleName getName() {
        return this.name;
    }

    @Override
    public void grantTo(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser) {
        connection.setConnectUser(systemUser);
        connection.executeSQLCommand("GRANT " + this.nameString + " TO " + sqlUser.getName().get());
    }

    @Override
    public MissingPrivileges checkPrivileges(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser) {
        ArrayList<Object> missingRoles = new ArrayList();
        MissingPrivileges missingPriv = new MissingPrivileges(this);
        connection.setConnectUser(systemUser);
        if (!this.exists(connection, systemUser)) {
            LogFactory.writeLogEntry(this.getClass(), "Role " + this.getName() + " doesn't exist.");
            missingRoles.add(this.nameString);
            missingPriv.addMissingRoles(missingRoles);
            return missingPriv;
        }
        missingRoles = this.checkRoles(connection);
        ArrayList<String> missingSysPrivileges = this.checkSysPrivileges(connection, systemUser, sqlUser);
        ArrayList<String> missingExecutePrivileges = this.checkObjectPrivileges(connection, systemUser, sqlUser);
        missingPriv.addMissingRoles(missingRoles);
        missingPriv.addMissingSysPrivileges(missingSysPrivileges);
        missingPriv.addMissingObjectPrivileges(missingExecutePrivileges);
        return missingPriv;
    }

    private ArrayList<String> checkRoles(JdbcConnection connection) {
        ArrayList<String> missingRoles = new ArrayList<String>();
        for (String role : this.roles) {
            if (PrivilegesUtils.checkRole(connection, role, this.nameString)) continue;
            missingRoles.add(role);
        }
        return missingRoles;
    }

    private ArrayList<String> checkSysPrivileges(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser) {
        ArrayList<String> missingSysPrivileges = new ArrayList<String>();
        for (String privileg : this.systemPrivileges) {
            if (PrivilegesUtils.checkSysPrivilege(connection, privileg, this.nameString)) continue;
            missingSysPrivileges.add(privileg);
        }
        return missingSysPrivileges;
    }

    private ArrayList<String> checkObjectPrivileges(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser) {
        String[] objectPriv;
        PrivilegeObject priv;
        ArrayList<String> missingObjectPrivileges = new ArrayList<String>();
        for (String[] objectPriv2 : this.objectPrivileges) {
            PrivilegeObject priv2 = new PrivilegeObject(objectPriv2, this.nameString);
            if (PrivilegesUtils.checkObjectPrivilege(connection, priv2, this.nameString)) continue;
            missingObjectPrivileges.add(priv2.toString());
        }
        connection.setConnectUser(sqlUser);
        if (BasisUtils.tableExists("CVERS", connection) && !PrivilegesUtils.checkObjectPrivilege(connection, priv = new PrivilegeObject(objectPriv = new String[]{sqlUser.getName().get(), "CVERS", "SELECT"}, this.nameString), this.nameString)) {
            missingObjectPrivileges.add(priv.toString());
        }
        if (BasisUtils.tableExists("SVERS", connection) && !PrivilegesUtils.checkObjectPrivilege(connection, priv = new PrivilegeObject(objectPriv = new String[]{sqlUser.getName().get(), "SVERS", "SELECT"}, this.nameString), this.nameString)) {
            missingObjectPrivileges.add(priv.toString());
        }
        return missingObjectPrivileges;
    }
}

