/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user.role;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRole;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class MissingPrivileges {
    ArrayList<String> missingRoles = new ArrayList();
    ArrayList<String> missingSysPrivileges = new ArrayList();
    ArrayList<String> missingObjectPrivileges = new ArrayList();
    ArrayList<String[]> missingConfigurations = new ArrayList();

    public MissingPrivileges(DatabaseUserRole userRole) {
    }

    public MissingPrivileges() {
    }

    public ArrayList<String> getMissingRoles() {
        return this.missingRoles;
    }

    public void addMissingRoles(ArrayList<String> missingRoles) {
        this.missingRoles.addAll(missingRoles);
    }

    public ArrayList<String> getMissingSysPrivileges() {
        return this.missingSysPrivileges;
    }

    public void addMissingSysPrivileges(ArrayList<String> missingSysPrivileges) {
        this.missingSysPrivileges.addAll(missingSysPrivileges);
    }

    public ArrayList<String> getMissingObjectPrivileges() {
        return this.missingObjectPrivileges;
    }

    public void addMissingObjectPrivileges(ArrayList<String> missingObjectPrivileges) {
        this.missingObjectPrivileges.addAll(missingObjectPrivileges);
    }

    public ArrayList<String[]> getMissingConfigurations() {
        return this.missingConfigurations;
    }

    public void addMissingConfigurations(ArrayList<String[]> missingConfigurations) {
        this.missingConfigurations.addAll(missingConfigurations);
    }

    public void addMissingPrivileges(MissingPrivileges object) {
        this.missingRoles.addAll(object.getMissingRoles());
        this.missingSysPrivileges.addAll(object.getMissingSysPrivileges());
        this.missingObjectPrivileges.addAll(object.getMissingObjectPrivileges());
        this.missingConfigurations.addAll(object.getMissingConfigurations());
    }

    public boolean hasMissing() {
        return !this.missingRoles.isEmpty() || !this.missingSysPrivileges.isEmpty() || !this.missingObjectPrivileges.isEmpty() || !this.missingConfigurations.isEmpty();
    }

    public void writeToResultFile(ResultFileWriter writer) {
        for (String role : this.missingRoles) {
            writer.append(role);
        }
        for (String sysPriv : this.missingSysPrivileges) {
            writer.append(sysPriv);
        }
        for (String objectPriv : this.missingObjectPrivileges) {
            writer.append(objectPriv);
        }
    }

    public void writeToHtmlFile() {
        PrintWriter pw = this.createHtmlWriter("./missingPrivileges.html");
        pw.println("<!DOCTYPE html>");
        pw.println("<html>");
        pw.println("<style>table, th, td {border: 1px solid black; border-collapse: collapse;}</style>");
        pw.println("<head>");
        pw.println("<h1>Missing privileges</h1>");
        pw.println("<body>");
        pw.println("<table>");
        if (!this.missingRoles.isEmpty()) {
            pw.println("<tr><th>Missing Roles:</th></tr>");
            for (String string : this.missingRoles) {
                pw.println("<tr><td>");
                pw.println(string);
                pw.println("</td></tr>");
            }
            pw.println("</table>");
            pw.println("<br/>");
        }
        if (!this.missingSysPrivileges.isEmpty()) {
            pw.println("<table>");
            pw.println("<tr><th>Missing System Privileges:</th></tr>");
            for (String string : this.missingSysPrivileges) {
                pw.println("<tr><td>");
                pw.println(string);
                pw.println("</td></tr>");
            }
            pw.println("</table>");
            pw.println("<br/>");
        }
        if (!this.missingObjectPrivileges.isEmpty()) {
            pw.println("<table>");
            pw.println("<tr><th>Missing Object Privileges:</th></tr>");
            for (String string : this.missingObjectPrivileges) {
                pw.println("<tr><td>");
                pw.println(string);
                pw.println("</td></tr>");
            }
            pw.println("</table>");
            pw.println("<br/>");
        }
        if (!this.missingConfigurations.isEmpty()) {
            pw.println("<table>");
            pw.println("<tr><th>Missing Configurations:</th></tr>");
            for (Object[] objectArray : this.missingConfigurations) {
                pw.println("<tr><td>");
                pw.println(Arrays.toString(objectArray));
                pw.println("</td></tr>");
            }
            pw.println("</table>");
            pw.println("<br/>");
        }
        pw.println("</body>");
        pw.println("</html>");
        pw.flush();
    }

    private PrintWriter createHtmlWriter(String htmlFile) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(htmlFile);
        }
        catch (FileNotFoundException e) {
            throw new HdbException(e.getMessage());
        }
        return pw;
    }
}

