/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user.role;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class PrivilegeObject {
    String roleName;
    String schemaName;
    String objectName;
    String privilege;
    String grantee;
    String sinceBasis;

    public PrivilegeObject(String[] objectPriv) {
        this.schemaName = objectPriv[0];
        this.objectName = objectPriv[1];
        this.privilege = objectPriv[2];
        if (objectPriv.length > 3) {
            this.sinceBasis = objectPriv[3];
        }
    }

    public PrivilegeObject(String[] objectPriv, String roleName) {
        this(objectPriv);
        this.setRoleName(roleName);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getPrivilege() {
        return this.privilege;
    }

    public void setPrivilege(String privilege) {
        this.privilege = privilege;
    }

    public String getGrantee() {
        return this.grantee;
    }

    public void setGrantee(String grantee) {
        this.grantee = grantee;
    }

    public String getSinceBasis() {
        return this.sinceBasis;
    }

    public void setSinceBasis(String sinceBasis) {
        this.sinceBasis = sinceBasis;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public boolean exists(JdbcConnection connection) {
        List<String> result;
        PreparedStatement statement;
        boolean schemaExists = false;
        boolean objectExists = false;
        boolean privilegeExists = false;
        if (this.schemaName != null && this.schemaName != "") {
            statement = connection.prepareSQLCommand("SELECT TOP 1 COUNT(*) FROM SYS.SCHEMAS WHERE SCHEMA_NAME=?");
            try {
                statement.setString(1, this.schemaName);
            }
            catch (SQLException e) {
                throw new HdbException(e);
            }
            result = connection.executeSQLCommand(statement);
            if ("0".equals(result.get(0))) {
                schemaExists = false;
                return schemaExists;
            }
            if ("1".equals(result.get(0))) {
                schemaExists = true;
            }
        } else {
            schemaExists = true;
        }
        if (this.objectName != null && this.objectName != "") {
            statement = connection.prepareSQLCommand("SELECT TOP 1 COUNT(*) FROM SYS.OBJECTS WHERE OBJECT_NAME=? AND SCHEMA_NAME=?");
            try {
                statement.setString(1, this.objectName);
                statement.setString(2, this.schemaName);
            }
            catch (SQLException e) {
                throw new HdbException(e);
            }
            result = connection.executeSQLCommand(statement);
            if ("0".equals(result.get(0))) {
                objectExists = false;
                return objectExists;
            }
            if ("1".equals(result.get(0))) {
                objectExists = true;
            }
        } else {
            objectExists = true;
        }
        if (this.privilege != null && this.privilege != "") {
            statement = connection.prepareSQLCommand("SELECT TOP 1 COUNT(*) FROM SYS.PRIVILEGES WHERE NAME=?");
            try {
                statement.setString(1, this.privilege);
            }
            catch (SQLException e) {
                throw new HdbException(e);
            }
            result = connection.executeSQLCommand(statement);
            if ("0".equals(result.get(0))) {
                privilegeExists = false;
            }
            if ("1".equals(result.get(0))) {
                privilegeExists = true;
            }
        } else {
            privilegeExists = true;
        }
        return privilegeExists;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.roleName != null && this.roleName != "") {
            sb.append("Role " + this.roleName + ": ");
        }
        if (this.privilege != null && this.privilege != "") {
            sb.append(this.privilege + " ");
        }
        if (this.schemaName != null && this.schemaName != "") {
            sb.append("ON SCHEMA " + this.schemaName + " ");
        }
        if (this.objectName != null && this.objectName != "") {
            sb.append("ON OBJECT " + this.objectName + " ");
        }
        if (this.grantee != null && this.grantee != "") {
            sb.append("TO " + this.grantee);
        }
        if (this.sinceBasis != null && this.sinceBasis != "") {
            sb.append("NEEDED SINCE " + this.sinceBasis + " SAP_BASIS");
        }
        return sb.toString();
    }
}

