/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user.role;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRole;
import com.sap.hdb.sl.lib.user.role.MissingPrivileges;
import com.sap.hdb.sl.lib.user.role.PrivilegeObject;
import com.sap.hdb.sl.lib.utils.IOUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PrivilegesUtils {
    private static String userGroup = "ABAPUSERGROUP";

    public static MissingPrivileges checkRoleIfExist(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser, DatabaseUserRole role) {
        MissingPrivileges missingPriv = new MissingPrivileges(role);
        connection.setConnectUser(systemUser);
        if (role.exists(connection, systemUser)) {
            ArrayList<String> missingRoles = new ArrayList<String>();
            if (!PrivilegesUtils.checkRole(connection, role.getName().get(), sqlUser.getName().get())) {
                missingRoles.add(role.getName().get());
                missingPriv.addMissingRoles(missingRoles);
            }
        }
        return missingPriv;
    }

    public static boolean checkRole(JdbcConnection connection, String role, String grantee) {
        String grantedRolesSql = "SELECT TOP 1 COUNT(*) FROM SYS.GRANTED_ROLES WHERE ROLE_NAME = ? AND GRANTEE = ?";
        PreparedStatement statement = null;
        statement = connection.prepareSQLCommand(grantedRolesSql);
        try {
            statement.setString(1, role);
            statement.setString(2, grantee);
            List<String> result = connection.executeSQLCommand(statement);
            if (!result.isEmpty()) {
                int cnt = Integer.parseInt(result.get(0));
                boolean bl = cnt > 0;
                return bl;
            }
        }
        catch (SQLException e) {
            LogFactory.writeLogEntry(PrivilegesUtils.class, "Error during execution of " + grantedRolesSql + " " + e.getMessage() + "(SQL error code: " + e.getErrorCode() + ")");
            throw new HdbException(e);
        }
        finally {
            IOUtils.closeQuietly(statement);
        }
        return false;
    }

    public static boolean checkSysPrivilege(JdbcConnection connection, String privilege, String grantee) {
        String grantedPrivSql = "SELECT TOP 1 COUNT(*) FROM SYS.GRANTED_PRIVILEGES WHERE PRIVILEGE = ? AND GRANTEE = ?";
        PreparedStatement statement = null;
        statement = connection.prepareSQLCommand(grantedPrivSql);
        try {
            statement.setString(1, privilege);
            statement.setString(2, grantee);
            List<String> result = connection.executeSQLCommand(statement);
            if (!result.isEmpty()) {
                int cnt = Integer.parseInt(result.get(0));
                boolean bl = cnt > 0;
                return bl;
            }
        }
        catch (SQLException e) {
            LogFactory.writeLogEntry(PrivilegesUtils.class, "Error during execution of " + grantedPrivSql + " " + e.getMessage() + "(SQL error code: " + e.getErrorCode() + ")");
            throw new HdbException(e);
        }
        finally {
            IOUtils.closeQuietly(statement);
        }
        return false;
    }

    public static boolean checkObjectPrivilege(JdbcConnection connection, PrivilegeObject priv, String grantee) {
        PreparedStatement statement;
        block7: {
            boolean bl;
            String objectName = priv.getObjectName();
            String schemaName = priv.getSchemaName();
            String privilege = priv.getPrivilege();
            StringBuffer grantedObjectPrivSql = new StringBuffer("SELECT TOP 1 COUNT(*) FROM SYS.GRANTED_PRIVILEGES WHERE GRANTEE = ? ");
            statement = null;
            try {
                if (!schemaName.equals("")) {
                    grantedObjectPrivSql.append("AND SCHEMA_NAME = '" + schemaName + "' ");
                }
                if (!objectName.equals("")) {
                    grantedObjectPrivSql.append("AND OBJECT_NAME = '" + objectName + "' ");
                }
                if (!privilege.equals("")) {
                    grantedObjectPrivSql.append("AND PRIVILEGE = '" + privilege + "' ");
                }
                statement = connection.prepareSQLCommand(grantedObjectPrivSql.toString());
                statement.setString(1, grantee);
                List<String> result = connection.executeSQLCommand(statement);
                if (result.isEmpty()) break block7;
                int cnt = Integer.parseInt(result.get(0));
                bl = cnt > 0;
            }
            catch (SQLException e) {
                try {
                    LogFactory.writeLogEntry(PrivilegesUtils.class, "Error during execution of " + grantedObjectPrivSql.toString() + " " + e.getMessage() + "(SQL error code: " + e.getErrorCode() + ")");
                    throw new HdbException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(statement);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(statement);
            return bl;
        }
        IOUtils.closeQuietly(statement);
        return false;
    }

    public static ArrayList<String> checkObjectPrivileges(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser, String[][] objectPrivileges, String roleName) {
        ArrayList<String> missingObjectPrivileges = new ArrayList<String>();
        for (String[] objectPriv : objectPrivileges) {
            PrivilegeObject priv = new PrivilegeObject(objectPriv, roleName);
            if (PrivilegesUtils.checkObjectPrivilege(connection, priv, roleName)) continue;
            missingObjectPrivileges.add(priv.toString());
        }
        return missingObjectPrivileges;
    }

    public static boolean checkUserGroup(JdbcConnection connection) {
        String usergroupOperator;
        String usergroupsSql = "select count(*) from SYS.USERGROUPS where USERGROUP_NAME = '" + userGroup + "'";
        List<String> result = connection.executeSQLCommand(usergroupsSql);
        if (result.get(0).equals("1") && (result = connection.executeSQLCommand(usergroupOperator = "SELECT count(*) FROM SYS.GRANTED_PRIVILEGES WHERE GRANTEE = CURRENT_USER AND OBJECT_TYPE = 'USERGROUP' AND OBJECT_NAME = '" + userGroup + "' AND PRIVILEGE in ('USERGROUP OPERATOR', 'OPERATOR');")).get(0).equals("0")) {
            LogFactory.writeLogEntry(PrivilegesUtils.class, "User " + connection.getConnectUser().getName().get() + " is not USERGROUP [OPERATOR] of USERGROUP " + userGroup + " !");
            return false;
        }
        return true;
    }
}

