/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user.role;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.DatabaseTable;
import com.sap.hdb.sl.lib.instance.SystemPrivilege;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRole;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleName;
import com.sap.hdb.sl.lib.user.role.MissingPrivileges;
import com.sap.hdb.sl.lib.user.role.PrivilegesUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class TableRedistributionRole
implements DatabaseUserRole {
    private DatabaseUserRoleName name;
    private String nameString;

    protected TableRedistributionRole(DatabaseUserRoleName name) {
        this.name = name;
        this.nameString = name.toString();
    }

    @Override
    public void createNewRole(JdbcConnection connection, DatabaseUser createUser, DatabaseUser grantUser) {
        connection.setConnectUser(createUser);
        if (!this.exists(connection, createUser)) {
            connection.executeSQLCommandNoReslt("CREATE ROLE " + this.nameString);
        }
        connection.setConnectUser(grantUser);
        try {
            SystemPrivilege[] systemPrivileges;
            for (SystemPrivilege systemPrivilege : systemPrivileges = new SystemPrivilege[]{new SystemPrivilege("SERVICE ADMIN"), new SystemPrivilege("RESOURCE ADMIN"), new SystemPrivilege("TABLE ADMIN")}) {
                if (systemPrivilege.exists(connection)) {
                    connection.executeSQLCommandNoReslt("GRANT " + systemPrivilege.getName() + " TO " + this.nameString);
                    continue;
                }
                LogFactory.writeLogEntry(this.getClass(), "The system privilege '" + systemPrivilege.getName() + "' doesn't exist.");
            }
            if (connection.getDbVersion() >= 4) {
                LogFactory.writeLogEntry(TableRedistributionRole.class, "HANA 4 does not have table _SYS_BI.M_SCHEMA_MAPPING. Skip Schema Mapping and _SYS_REPO.SCHEMAVERSION stuff...");
                return;
            }
            connection.executeSQLCommandNoReslt("GRANT SELECT ON _SYS_REPO.SCHEMAVERSION TO " + this.nameString);
            DatabaseTable table = new DatabaseTable("TABLE_PLACEMENT");
            table.setSchemaName("SYS");
            if (table.exists(connection)) {
                connection.executeSQLCommandNoReslt("GRANT SELECT ON SYS.TABLE_PLACEMENT TO " + this.nameString);
            } else {
                table.setSchemaName("_SYS_RT");
                if (table.exists(connection)) {
                    String stmtString = "CALL _SYS_REPO.GRANT_PRIVILEGE_ON_ACTIVATED_CONTENT('SELECT', '_SYS_RT.TABLE_PLACEMENT', '" + this.nameString + "')";
                    PreparedStatement stmt = connection.prepareSQLCommand(stmtString);
                    try {
                        stmt.execute();
                    }
                    catch (SQLException e) {
                        LogFactory.writeLogEntry(this.getClass(), "Error during execution of statement: \"" + stmtString + "\"; " + e.getMessage());
                        stmtString = "GRANT SELECT ON _SYS_RT.TABLE_PLACEMENT TO " + this.nameString;
                        LogFactory.writeLogEntry(this.getClass(), "Executing alternative statement: \"" + stmtString + " \"");
                        connection.executeSQLCommandNoReslt(stmtString);
                    }
                } else {
                    LogFactory.writeLogEntry(this.getClass(), "Table TABLE_PLACEMENT does not exist.");
                }
            }
        }
        catch (HdbException e) {
            this.dropRole(connection, createUser);
            throw e;
        }
    }

    @Override
    public void createNewRole(JdbcConnection connection, DatabaseUser user) {
        this.createNewRole(connection, user, user);
    }

    @Override
    public void dropRole(JdbcConnection connection, DatabaseUser systemUser) {
        if (this.exists(connection, systemUser)) {
            connection.executeSQLCommand("DROP ROLE " + this.nameString);
        }
    }

    @Override
    public boolean exists(JdbcConnection connection, DatabaseUser user) {
        List<String> result = this.executeStatement("SELECT ROLE_NAME FROM ROLES", connection, user);
        for (String resultString : result) {
            if (!this.nameString.equalsIgnoreCase(resultString)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addSqlPrivileges(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser) {
    }

    @Override
    public DatabaseUserRoleName getName() {
        return this.name;
    }

    @Override
    public void grantTo(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser) {
        connection.setConnectUser(systemUser);
        connection.executeSQLCommand("GRANT " + this.nameString + " TO " + sqlUser.getName().get());
    }

    private List<String> executeStatement(String statement, JdbcConnection connection, DatabaseUser user) {
        connection.setConnectUser(user);
        return connection.executeSQLCommand(statement);
    }

    @Override
    public MissingPrivileges checkPrivileges(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser) {
        MissingPrivileges missingPriv = PrivilegesUtils.checkRoleIfExist(connection, systemUser, sqlUser, this);
        return missingPriv;
    }
}

