/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.user.role;

import com.sap.hdb.sl.lib.abap.BasisUtils;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.instance.Privilege;
import com.sap.hdb.sl.lib.instance.SystemPrivilege;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRole;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleName;
import com.sap.hdb.sl.lib.user.role.MissingPrivileges;
import com.sap.hdb.sl.lib.user.role.PrivilegeObject;
import com.sap.hdb.sl.lib.user.role.PrivilegesUtils;
import java.util.ArrayList;
import java.util.List;

public class UserRole
implements DatabaseUserRole {
    DatabaseUserRoleName name = null;
    String nameString = null;
    String[] roles = new String[]{"MONITORING", "CONTENT_ADMIN"};
    String[] systemPrivileges = new String[]{"SCENARIO ADMIN", "SAVEPOINT ADMIN", "ROLE ADMIN"};
    String[] optionalsystemPrivileges = new String[]{"OPTIMIZER ADMIN"};
    String[][] objectPrivileges = new String[][]{{"SYS", "TREXVIADBSL", "EXECUTE"}, {"SYS", "TREXVIADBSLWITHPARAMETER", "EXECUTE"}, {"SYS", "GET_PROCEDURE_OBJECTS", "EXECUTE"}, {"SYS", "TRUNCATE_PROCEDURE_OBJECTS", "EXECUTE"}, {"SYS", "GET_OBJECT_VERSION", "EXECUTE"}};
    String[][] optionalObjectPrivileges = new String[][]{{"SYS", "ANALYZE_SQLSCRIPT_DEFINITION", "EXECUTE", "753"}, {"SYS", "ANALYZE_SQLSCRIPT_OBJECTS", "EXECUTE", "753"}, {"SYS", "SQLSCRIPT_ANALYZER_RULES", "SELECT", "753"}, {"SYS", "GET_OBJECTS_IN_DDL_STATEMENT", "EXECUTE", "753"}, {"_SYS_REPO", "", "SELECT", "753"}, {"", "", "CLIENT PARAMETER ADMIN", "752"}};
    String[][] objectPrivilegesHanaCloud = new String[][]{{"SYS", "GET_PROCEDURE_OBJECTS", "EXECUTE"}, {"SYS", "TRUNCATE_PROCEDURE_OBJECTS", "EXECUTE"}, {"SYS", "GET_OBJECT_VERSION", "EXECUTE"}};

    protected UserRole(DatabaseUserRoleName name) {
        this.name = name;
        this.nameString = name.toString();
    }

    @Override
    public boolean exists(JdbcConnection connection, DatabaseUser systemUser) {
        boolean exists = false;
        List<String> result = this.executeStatement("SELECT ROLE_NAME FROM ROLES", connection, systemUser);
        for (String resultString : result) {
            if (!this.nameString.equalsIgnoreCase(resultString)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    @Override
    public void createNewRole(JdbcConnection connection, DatabaseUser createUser, DatabaseUser grantUser) {
        connection.setConnectUser(createUser);
        if (!this.exists(connection, createUser)) {
            this.executeStatement("CREATE ROLE " + this.nameString, connection, createUser);
        }
        connection.setConnectUser(grantUser);
        try {
            String[] bwUserGrants = connection.getDbVersion() < 4 ? new String[]{"GRANT MONITORING TO " + this.nameString, "GRANT CONTENT_ADMIN TO " + this.nameString, "GRANT SCENARIO ADMIN TO " + this.nameString, "GRANT SAVEPOINT ADMIN TO " + this.nameString, "GRANT ROLE ADMIN TO " + this.nameString, "GRANT " + (Object)((Object)Privilege.EXECUTE) + " ON SYS.TREXVIADBSL TO " + this.nameString, "GRANT " + (Object)((Object)Privilege.EXECUTE) + " ON SYS.TREXVIADBSLWITHPARAMETER TO " + this.nameString, "GRANT " + (Object)((Object)Privilege.EXECUTE) + " ON SYS.GET_PROCEDURE_OBJECTS TO " + this.nameString, "GRANT " + (Object)((Object)Privilege.EXECUTE) + " ON SYS.TRUNCATE_PROCEDURE_OBJECTS TO " + this.nameString, "GRANT " + (Object)((Object)Privilege.EXECUTE) + " ON SYS.GET_OBJECT_VERSION TO " + this.nameString, "GRANT OPTIMIZER ADMIN TO " + this.nameString} : new String[]{"GRANT MONITORING TO " + this.nameString, "GRANT CONTENT_ADMIN TO " + this.nameString, "GRANT SCENARIO ADMIN TO " + this.nameString, "GRANT SAVEPOINT ADMIN TO " + this.nameString, "GRANT ROLE ADMIN TO " + this.nameString, "GRANT " + (Object)((Object)Privilege.EXECUTE) + " ON SYS.GET_PROCEDURE_OBJECTS TO " + this.nameString, "GRANT " + (Object)((Object)Privilege.EXECUTE) + " ON SYS.TRUNCATE_PROCEDURE_OBJECTS TO " + this.nameString, "GRANT " + (Object)((Object)Privilege.EXECUTE) + " ON SYS.GET_OBJECT_VERSION TO " + this.nameString, "GRANT OPTIMIZER ADMIN TO " + this.nameString};
            String[] optionalGrants = new String[]{"GRANT " + (Object)((Object)Privilege.EXECUTE) + " ON SYS.ANALYZE_SQLSCRIPT_DEFINITION TO " + this.nameString, "GRANT " + (Object)((Object)Privilege.EXECUTE) + " ON SYS.ANALYZE_SQLSCRIPT_OBJECTS TO " + this.nameString, "GRANT " + (Object)((Object)Privilege.SELECT) + " ON SYS.SQLSCRIPT_ANALYZER_RULES TO " + this.nameString, "GRANT CLIENT PARAMETER ADMIN TO " + this.nameString, "GRANT " + (Object)((Object)Privilege.SELECT) + " ON SCHEMA _SYS_REPO TO " + this.nameString};
            String[] optionalAlterStmts = new String[]{};
            int sap_basis = BasisUtils.checkCVERSBasisRelease(connection, grantUser);
            if (754 == sap_basis || 0 == sap_basis) {
                optionalAlterStmts = new String[]{"ALTER SYSTEM ALTER CONFIGURATION('indexserver.ini', 'SYSTEM') SET ('dynamic_result_cache', 'enable_implicit_match') = 'true' WITH RECONFIGURE"};
            }
            this.executeStatements(bwUserGrants, connection, grantUser);
            this.executeOptionalStatements(optionalGrants, connection, grantUser);
            this.executeOptionalStatements(optionalAlterStmts, connection, grantUser);
            this.executeOptionalWithIniParameter(connection, grantUser);
            this.createWorkloadClass(connection, grantUser);
        }
        catch (HdbException e) {
            this.dropRole(connection, createUser);
            throw e;
        }
    }

    @Override
    public void createNewRole(JdbcConnection connection, DatabaseUser user) {
        this.createNewRole(connection, user, user);
    }

    @Override
    public void dropRole(JdbcConnection connection, DatabaseUser systemUser) {
        if (this.exists(connection, systemUser)) {
            connection.executeSQLCommand("DROP ROLE " + this.nameString);
        }
    }

    private List<String> executeStatement(String statement, JdbcConnection connection, DatabaseUser systemUser) {
        connection.setConnectUser(systemUser);
        return connection.executeSQLCommand(statement);
    }

    private void executeStatements(String[] statements, JdbcConnection connection, DatabaseUser systemUser) {
        for (String statement : statements) {
            this.executeStatement(statement, connection, systemUser);
        }
    }

    private void executeOptionalStatements(String[] statements, JdbcConnection connection, DatabaseUser systemUser) {
        for (String statement : statements) {
            this.executeOptionalStatement(statement, connection, systemUser);
        }
    }

    private boolean executeOptionalStatement(String statement, JdbcConnection connection, DatabaseUser systemUser) {
        try {
            this.executeStatement(statement, connection, systemUser);
            return true;
        }
        catch (HdbException e) {
            if (connection.getErrorCode() == 397) {
                LogFactory.writeLogEntry(this.getClass(), "Unable to execute optional statement '" + statement + "': Object doesn't exist.");
            } else if (connection.getErrorCode() == 659) {
                LogFactory.writeLogEntry(this.getClass(), "Unable to execute optional statement '" + statement + "': Workload class already exist.");
            } else {
                LogFactory.writeLogEntry(this.getClass(), "Unable to execute optional statement '" + statement + "': " + e.getMessage());
            }
            return false;
        }
    }

    private void executeOptionalWithIniParameter(JdbcConnection connection, DatabaseUser systemUser) {
        String statement = "GRANT " + (Object)((Object)Privilege.EXECUTE) + " ON SYS.GET_OBJECTS_IN_DDL_STATEMENT TO " + this.nameString;
        if (this.executeOptionalStatement(statement, connection, systemUser) && connection.getDbVersion() < 4) {
            DatabaseConfiguration config = new DatabaseConfiguration(connection, systemUser, DatabaseConfiguration.ConfigFileName.INDEXSERVER_INI);
            DatabaseConfigurationSection section = config.getSection("sqlscript");
            section.setParameter("enable_builtin_procedure_get_objects_in_ddl_statement", "true");
        }
    }

    private void createWorkloadClass(JdbcConnection connection, DatabaseUser systemUser) {
        String createStatement = "CREATE WORKLOAD CLASS PFW_COLLECTOR SET 'STATEMENT TIMEOUT' = '10'";
        this.executeOptionalStatement(createStatement, connection, systemUser);
    }

    @Override
    public void addSqlPrivileges(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser) {
    }

    @Override
    public DatabaseUserRoleName getName() {
        return this.name;
    }

    @Override
    public void grantTo(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser) {
        connection.setConnectUser(systemUser);
        connection.executeSQLCommand("GRANT " + this.nameString + " TO " + sqlUser.getName().get());
    }

    @Override
    public MissingPrivileges checkPrivileges(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser) {
        ArrayList<Object> missingRoles = new ArrayList();
        MissingPrivileges missingPriv = new MissingPrivileges(this);
        connection.setConnectUser(systemUser);
        if (!this.exists(connection, systemUser)) {
            LogFactory.writeLogEntry(this.getClass(), "Role " + this.getName() + " doesn't exist.");
            missingRoles.add(this.nameString);
            missingPriv.addMissingRoles(missingRoles);
            return missingPriv;
        }
        missingRoles = this.checkRoles(connection);
        ArrayList<String> missingSysPrivileges = this.checkSysPrivileges(connection, systemUser, sqlUser);
        ArrayList<String> missingObjectPrivileges = this.checkObjectPrivileges(connection, systemUser, sqlUser);
        missingPriv.addMissingRoles(missingRoles);
        missingPriv.addMissingSysPrivileges(missingSysPrivileges);
        missingPriv.addMissingObjectPrivileges(missingObjectPrivileges);
        return missingPriv;
    }

    private ArrayList<String> checkRoles(JdbcConnection connection) {
        ArrayList<String> missingRoles = new ArrayList<String>();
        for (String role : this.roles) {
            if (PrivilegesUtils.checkRole(connection, role, this.nameString)) continue;
            missingRoles.add(role);
        }
        return missingRoles;
    }

    private ArrayList<String> checkSysPrivileges(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser) {
        ArrayList<String> missingSysPrivileges = new ArrayList<String>();
        for (String privileg : this.systemPrivileges) {
            if (PrivilegesUtils.checkSysPrivilege(connection, privileg, this.nameString)) continue;
            missingSysPrivileges.add(privileg);
        }
        for (String optionalPriv : this.optionalsystemPrivileges) {
            SystemPrivilege privileg = new SystemPrivilege(optionalPriv);
            if (!privileg.exists(connection) || PrivilegesUtils.checkSysPrivilege(connection, optionalPriv, this.nameString)) continue;
            missingSysPrivileges.add(optionalPriv);
        }
        return missingSysPrivileges;
    }

    private ArrayList<String> checkObjectPrivileges(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser sqlUser) {
        PrivilegeObject priv;
        ArrayList<String> missingObjectPrivileges = new ArrayList<String>();
        if (connection.getDbVersion() < 4) {
            for (String[] objectPriv : this.objectPrivileges) {
                priv = new PrivilegeObject(objectPriv, this.nameString);
                if (PrivilegesUtils.checkObjectPrivilege(connection, priv, this.nameString)) continue;
                missingObjectPrivileges.add(priv.toString());
            }
        } else {
            for (String[] objectPriv : this.objectPrivilegesHanaCloud) {
                priv = new PrivilegeObject(objectPriv, this.nameString);
                if (PrivilegesUtils.checkObjectPrivilege(connection, priv, this.nameString)) continue;
                missingObjectPrivileges.add(priv.toString());
            }
        }
        for (String[] objectPriv : this.optionalObjectPrivileges) {
            int from_basis;
            int basis;
            priv = new PrivilegeObject(objectPriv, this.nameString);
            if (!priv.exists(connection) || PrivilegesUtils.checkObjectPrivilege(connection, priv, this.nameString) || objectPriv.length <= 3 || (basis = BasisUtils.checkCVERSBasisRelease(connection, sqlUser)) <= 0 || (from_basis = Integer.parseInt(objectPriv[3])) > basis) continue;
            missingObjectPrivileges.add(priv.toString());
        }
        return missingObjectPrivileges;
    }
}

