/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.sapcontrol.ArrayOfString;
import com.sap.hdb.sl.lib.sapcontrol.SAPControlPortType;
import com.sap.hdb.sl.lib.utils.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.xml.ws.Holder;

public class BackupArchive
implements Runnable {
    private static int conCounter;
    private static Properties result;
    private static final String SUCCESS = "SUCCESS";
    private static final String INITIAL = "INITIAL";
    private static final String ERROR = "ERROR";
    private static final String INSERTING = "INSERTING";
    private static final String DOWNLOADING = "DOWNLOADING";
    private static final String CONNECTED = "CONNECTED";
    private static final String FINALIZING = "FINALIZING";
    private static final String RETRY = "RETRY";
    private static int maxConnections;
    private static int maxRetries;
    private Connection con;
    private File path;
    private String tableName;
    private boolean success;
    private String url;
    private String user;
    private String password;
    private static URLClassLoader loader;
    private File driver;
    private String fileName;
    private URL[] driverURL;
    private PrintStream out;
    private Properties properties;
    private SAPControlPortType port = null;
    private String pyCommand = null;

    public BackupArchive(String path, String driver, String url, String user, String pw, Properties properties) throws Exception {
        this.path = new File(path);
        if (!(this.path.exists() && this.path.isFile() && this.path.canRead())) {
            throw new Exception("ERROR: BackupArchive " + path + " not accessible.");
        }
        this.url = url;
        this.user = user;
        this.password = pw;
        this.driver = new File(driver);
        this.fileName = this.path.getName();
        this.tableName = BackupArchive.getTableNameFromFilename(this.path.getName());
        this.properties = properties;
        URL[] driverURL = new URL[]{this.driver.toURI().toURL()};
        this.driverURL = driverURL;
        this.setLoggin();
        this.setStatus(this.getName(), INITIAL);
    }

    public BackupArchive(String path, String driver, String url, String user, String pw, Properties properties, SAPControlPortType port, String command) throws Exception {
        this.path = new File(path);
        if (!(this.path.exists() && this.path.isFile() && this.path.canRead())) {
            throw new Exception("ERROR: BackupArchive " + path + " not accessible.");
        }
        this.url = url;
        this.user = user;
        this.password = pw;
        this.driver = new File(driver);
        this.fileName = this.path.getName();
        this.tableName = BackupArchive.getTableNameFromFilename(this.path.getName());
        this.properties = properties;
        URL[] driverURL = new URL[]{this.driver.toURI().toURL()};
        this.driverURL = driverURL;
        this.setLoggin();
        this.setStatus(this.getName(), INITIAL);
        this.port = port;
        this.pyCommand = command;
    }

    private void setLoggin() throws IOException {
        File log = new File(this.getName() + ".log");
        FileOutputStream fout = new FileOutputStream(log);
        this.out = new PrintStream(fout);
        this.out.println("---------------------------- Begin logging ----------------------------");
    }

    private void log(String line) {
        this.out.println(new Timestamp(System.currentTimeMillis()) + ": " + line);
    }

    private static Connection getConnection(String name, URL[] driver, Properties prop, String url) throws Exception {
        loader = new URLClassLoader(driver, System.class.getClassLoader());
        Class<?> driverClass = loader.loadClass("com.sap.db.jdbc.Driver");
        if (!Driver.class.isAssignableFrom(driverClass)) {
            throw new HdbException("Class com.sap.db.jdbc.Driver is not a java.sql.Driver.");
        }
        Driver ngdbc = (Driver)driverClass.newInstance();
        while (true) {
            if (BackupArchive.upCounter()) break;
            Thread.sleep(5000L);
        }
        Connection con = ngdbc.connect(url, prop);
        return con;
    }

    private static boolean upCounter() {
        if (conCounter < BackupArchive.getMaxConnections()) {
            BackupArchive.updateCount(1);
            return true;
        }
        return false;
    }

    private static void downCounter() {
        BackupArchive.updateCount(-1);
    }

    private static synchronized void updateCount(int i) {
        conCounter += i;
    }

    private synchronized void setStatus(String name, String status) {
        result.setProperty(name, status);
    }

    public static String getTableNameFromPath(String pathString) {
        return new File(pathString).getName().toUpperCase(Locale.ENGLISH).replace('.', '_');
    }

    private static String getTableNameFromFilename(String archiveName) {
        return archiveName.toUpperCase(Locale.ENGLISH).replace('.', '_');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.success = false;
        Properties prop = this.properties;
        prop.setProperty("user", this.user);
        prop.setProperty("password", this.password);
        boolean success = false;
        PreparedStatement pstmt = null;
        Statement stmt = null;
        for (int r = 1; r <= BackupArchive.getMaxRetries(); ++r) {
            try {
                if (r > 1) {
                    this.out.println("----------------------------   Retrying  ----------------------------");
                }
                this.con = BackupArchive.getConnection(this.getName(), this.driverURL, prop, this.url);
                this.setStatus(this.getName(), CONNECTED);
                this.log("Loading archive " + this.path.getName() + "... (Try number " + r + ").");
                long start = System.nanoTime();
                stmt = this.con.createStatement();
                try {
                    stmt.execute("DROP TABLE \"" + this.tableName + "\"");
                }
                catch (SQLException e) {
                    this.log("WARNING: " + this.tableName + " not dropped. [" + e.toString() + "]");
                }
                stmt.execute("CREATE TABLE \"" + this.tableName + "\" (ARCHIVE_NAME CHAR(50), ARCHIVE BLOB MEMORY THRESHOLD 1000)");
                this.log("Insert " + this.path.getName() + " into \"" + this.tableName + "\": starting.");
                System.out.println(this.getTableName() + ": Upload starting.");
                stmt.executeUpdate("UPDATE ARCHIVES SET STATUS = 'UPLOADING' WHERE ARCHIVE_TABLE = '" + this.getTableName() + "'");
                FileInputStream inputStream = new FileInputStream(this.path);
                this.setStatus(this.getName(), INSERTING);
                pstmt = this.con.prepareStatement("INSERT INTO \"" + this.tableName + "\" values ('" + this.fileName + "', ?)");
                pstmt.setBlob(1, inputStream);
                pstmt.execute();
                pstmt.close();
                long end = System.nanoTime();
                stmt.executeUpdate("UPDATE ARCHIVES SET STATUS = 'LOADED' WHERE ARCHIVE_TABLE = '" + this.getTableName() + "'");
                this.log("Insert " + this.path.getName() + " into \"" + this.tableName + "\": successful. (Elapsed time: " + BackupArchive.duration(start, end, true) + " minutes)");
                if (this.port != null) {
                    this.setStatus(this.getName(), DOWNLOADING);
                    System.out.println(this.getTableName() + ": Upload finished.");
                    BackupArchive.downCounter();
                    stmt.executeUpdate("UPDATE ARCHIVES SET STATUS = 'DOWNLOADING' WHERE ARCHIVE_TABLE = '" + this.getTableName() + "'");
                    System.out.println(this.getTableName() + ": Download started.");
                    if (!this.downloadAndUnzipBackupWithPython(this.tableName)) {
                        System.out.println(this.getTableName() + " archive extraction failed.");
                        throw new HdbException(this.getTableName() + " archive extraction failed.");
                    }
                    System.out.println(this.getTableName() + " archive extracted successfully.");
                    System.out.println(this.getTableName() + ": Download finished.");
                    end = System.nanoTime();
                    this.log("Download from \"" + this.tableName + "\": successful. (Elapsed time: " + BackupArchive.duration(start, end, true) + " minutes)");
                    stmt.executeUpdate("UPDATE ARCHIVES SET STATUS = 'FINISHED' WHERE ARCHIVE_TABLE = '" + this.getTableName() + "'");
                    this.success = true;
                } else {
                    this.success = true;
                    BackupArchive.downCounter();
                }
                stmt.close();
                this.setStatus(this.getName(), FINALIZING);
                this.con.close();
                success = true;
                this.setStatus(this.getName(), SUCCESS);
                IOUtils.closeQuietly(pstmt);
            }
            catch (Exception e) {
                BackupArchive.downCounter();
                this.log("Insert " + this.path.getName() + " into " + this.tableName + ": failed.");
                e.printStackTrace(this.out);
                if (r >= BackupArchive.getMaxRetries()) {
                    this.setStatus(this.getName(), ERROR);
                }
                this.setStatus(this.getName(), RETRY);
                try {
                    Thread.sleep(10000L);
                    if (e.toString().indexOf("GLOBAL_ALLOCATION_LIMIT") != -1) {
                        this.log("Out of Memory error... go to sleep for a minute.");
                        Thread.sleep(60000L);
                    }
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                {
                }
            }
            finally {
                IOUtils.closeQuietly(pstmt);
                IOUtils.closeQuietly(this.con);
                if (success) break;
            }
            IOUtils.closeQuietly(this.con);
            if (!success) continue;
            break;
        }
        this.out.println("---------------------------- End logging ----------------------------");
        this.out.flush();
        this.out.close();
    }

    public boolean downloadAndUnzipBackupWithPython(String table_name) {
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        String traceFile = table_name + "_ARCHIVE_DOWNLOAD_EXTRACT.trc";
        String command = this.pyCommand + " " + table_name;
        this.log("Execute " + command + " remotely. Output written to file " + traceFile + " in the HANA host trace directory.");
        this.port.osExecute(command, 0, 0, traceFile, (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            this.log("Archives download/extract failed. (pid=" + (pid == null ? "null" : (Serializable)pid.value) + "). " + "For more details, check trace file " + "trace/" + traceFile + ".");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
            }
            return false;
        }
        this.log("Backup archives downloaded and extracted. (pid=" + (pid == null ? "null" : (Serializable)pid.value) + ")");
        return true;
    }

    public static String durationMin(long start, long end) {
        return BackupArchive.duration(start, end, false);
    }

    public static String duration(long start, long end, boolean millis) {
        long duration = TimeUnit.MILLISECONDS.convert(end - start, TimeUnit.NANOSECONDS);
        long min = 0L;
        long sec = 0L;
        long msec = 0L;
        if (duration > 60000L) {
            min = TimeUnit.MINUTES.convert(duration, TimeUnit.MILLISECONDS);
            duration %= 60000L;
        }
        if (duration > 1000L) {
            sec = TimeUnit.SECONDS.convert(duration, TimeUnit.MILLISECONDS);
            duration %= 1000L;
        }
        String msecs = "";
        if (millis) {
            msec = duration;
            msecs = ".";
            if (msec < 100L) {
                msecs = msecs + "0";
            }
            if (msec < 10L) {
                msecs = msecs + "0";
            }
            msecs = msecs + msec;
        }
        return (min < 10L ? "0" + min : Long.valueOf(min)) + ":" + (sec < 10L ? "0" + sec : Long.valueOf(sec)) + msecs;
    }

    public String getName() {
        return this.path.getName();
    }

    public static Properties getStatus() {
        return result;
    }

    public static int getCounter() {
        return conCounter;
    }

    public static int getMaxConnections() {
        return maxConnections;
    }

    public static void setMaxConnections(int maxConnections) {
        BackupArchive.maxConnections = maxConnections;
    }

    public static int getMaxRetries() {
        return maxRetries;
    }

    public static void setMaxRetries(int max) {
        maxRetries = max;
    }

    public String getTableName() {
        return this.tableName;
    }

    static {
        result = new Properties();
        maxConnections = 10;
        maxRetries = 10;
    }
}

