/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils;

import com.sap.hdb.sl.lib.utils.HdbInstOption;
import com.sap.hdb.sl.lib.utils.HdbUninstOption;
import java.util.ArrayList;
import java.util.Locale;

public class CommandList
extends ArrayList<String> {
    private static final long serialVersionUID = 1826129002767007884L;

    public CommandList(String[] args) {
        for (String arg : args) {
            this.add(arg);
        }
    }

    public CommandList() {
    }

    public String[] toArray() {
        return this.toArray(new String[this.size()]);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            buffer.append((String)this.get(i));
            if (i >= this.size() - 1) continue;
            buffer.append(" ");
        }
        buffer.trimToSize();
        return buffer.toString();
    }

    public void add(HdbInstOption option) {
        this.add(option.toString());
    }

    public void add(HdbUninstOption option) {
        this.add(option.toString());
    }

    public void add(HdbInstOption option, String value) {
        String optionString = option.get();
        if (this.contains(option)) {
            this.remove(option);
        }
        if (optionString.startsWith("--") && !value.isEmpty()) {
            super.add(optionString + "=" + value);
        } else {
            super.add(optionString);
            super.add(value);
        }
    }

    public void remove(HdbInstOption option) {
        for (int i = 0; i < super.size(); ++i) {
            String s = option.toString().toLowerCase(Locale.ENGLISH);
            String line = (String)super.get(i);
            if (!line.startsWith(s)) continue;
            super.remove(i);
            break;
        }
    }

    public boolean contains(HdbInstOption option) {
        boolean contains = false;
        for (String line : this) {
            String s;
            if (!line.startsWith(s = option.toString().toLowerCase(Locale.ENGLISH))) continue;
            contains = true;
            break;
        }
        return contains;
    }
}

