/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.instance.DatabaseXmlParameter;
import com.sap.hdb.sl.lib.instance.XmlParameters;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.utils.cmd.clazz.AbapPreLoadExecution;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DatabaseParameterHelper {
    private XmlParameters xmlParameters = null;

    public DatabaseParameterHelper(XmlParameters xmlParameters) {
        this.xmlParameters = xmlParameters;
    }

    public void setParameterValues(JdbcConnection connection, DatabaseSystemUser systemUser) {
        File parameterFile = new File(AbapPreLoadExecution.PARAMETER_FILE_NAME);
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(parameterFile));
            NodeList parameterNodes = this.xmlParameters.getParameterXmlDocument().getElementsByTagName("Parameter");
            for (int i = 0; i < parameterNodes.getLength(); ++i) {
                DatabaseXmlParameter parameter;
                Node parameterNode = parameterNodes.item(i);
                try {
                    parameter = DatabaseXmlParameter.fromXml(parameterNode);
                }
                catch (HdbException e) {
                    LogFactory.writeLogEntry(this.getClass(), "Invalid parameter: " + e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    LogFactory.writeLogEntry(this.getClass(), "Invalid parameter: " + e.getMessage());
                    throw new HdbException(e);
                }
                if (DatabaseConfiguration.ConfigFileName.GLOBAL_INI == parameter.getConfigurationFileName() && "table_placement".equalsIgnoreCase(parameter.getSectionName()) && "bw_schema".equals(parameter.getParameterName())) {
                    LogFactory.writeLogEntry(DatabaseXmlParameter.class, "Illegal parameter. Parameter 'bw_schema' is set automatically and cannot be overwritten.");
                    continue;
                }
                DatabaseConfiguration databaseConfiguration = new DatabaseConfiguration(connection, systemUser, parameter.getConfigurationFileName());
                DatabaseConfigurationSection databaseConfigurationSection = databaseConfiguration.getSection(parameter.getSectionName());
                if (!parameter.isDefaultParameter() && !parameter.isPersistent()) {
                    String oldParameterValue = databaseConfigurationSection.getParameterValue(parameter.getParameterName());
                    bw.write(parameter.getConfigurationFileName().toString() + "|" + parameter.getSectionName().toString() + "|" + parameter.getParameterName() + "|" + oldParameterValue);
                    bw.newLine();
                }
                databaseConfigurationSection.setParameter(parameter.getParameterName(), parameter.getParameterValue());
            }
        }
        catch (IOException e) {
            LogFactory.writeLogEntry(this.getClass(), "Error writing database parameter values to file '" + parameterFile + "': " + e.getMessage());
            throw new HdbException(e);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

