/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.operating.system.HdbEnvironmentVariable;
import com.sap.hdb.sl.lib.operating.system.HdbEnvironmentVariableList;
import com.sap.hdb.sl.lib.operating.system.HdbEnvironmentVariableName;
import com.sap.hdb.sl.lib.operating.system.HdbEnvironmentVariableValue;
import com.sap.hdb.sl.lib.operating.system.OsToolBox;
import com.sap.hdb.sl.lib.utils.HdbInstOption;
import com.sap.hdb.sl.lib.utils.InstallationParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzNameIF;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterNameIF;
import java.util.ArrayList;
import java.util.List;

public class GenericInstallationParameter
implements InstallationParameter,
CmdClazzParameter {
    private CmdClazzParameterNameIF name = null;
    private String value = null;
    private HdbInstOption hdbInstOption = null;
    private String option = null;

    public GenericInstallationParameter(String option, String value) {
        this.value = value;
        this.hdbInstOption = HdbInstOption.GENERIC_OPTION;
        this.option = option;
    }

    @Override
    public CmdClazzParameterNameIF getCmdClazzParameterName() {
        if (null == this.name) {
            throw new HdbException("Generic Installation Parameter does not have a CmdClazzParameterName");
        }
        return this.name;
    }

    @Override
    public void setCmdClazzParameterName(CmdClazzParameterNameIF name) {
        this.name = name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public HdbInstOption getHdbInstOption() {
        this.hdbInstOption.set(this.option);
        return this.hdbInstOption;
    }

    public static List<InstallationParameter> getParameters(HdbEnvironmentVariableList envVarList, OsToolBox osToolbox, CmdClazzNameIF currentCmdClazzname) {
        ArrayList<InstallationParameter> list = new ArrayList<InstallationParameter>();
        for (HdbEnvironmentVariable variable : envVarList) {
            HdbEnvironmentVariableName varName = variable.getName();
            if (!varName.equals(HdbEnvironmentVariableName.EnvironmentVariableName.HDB_INSTALLATION_PARAMETER) && (!varName.startsWith(HdbEnvironmentVariableName.EnvironmentVariableName.HDB_INSTALLATION_PARAMETER) || !varName.endsWithClazzName(currentCmdClazzname))) continue;
            HdbEnvironmentVariableValue varValue = variable.getValue();
            List<String[]> optionValues = varValue.split(osToolbox);
            for (String[] optionValue : optionValues) {
                GenericInstallationParameter newParameter = new GenericInstallationParameter(optionValue[0], optionValue[1]);
                list.add(newParameter);
            }
        }
        return list;
    }
}

