/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.operating.system.ExternalProcess;
import com.sap.hdb.sl.lib.operating.system.OsToolBox;
import com.sap.hdb.sl.lib.operating.system.OsToolboxFactory;
import com.sap.hdb.sl.lib.operating.system.WinVersion;
import com.sap.hdb.sl.lib.utils.CommandList;
import com.sap.hdb.sl.lib.utils.GenericInstallationParameter;
import com.sap.hdb.sl.lib.utils.HdbInstExecutable;
import com.sap.hdb.sl.lib.utils.HdbInstOption;
import com.sap.hdb.sl.lib.utils.InstallationParameter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HdbInst
extends ExternalProcess {
    private static final String HANA_VERSION_PATTERN_STRING = "[0-9]{1,2}\\.[0-9]{2}\\.[0-9]{2}\\.[0-9]{6,}";
    private static final Pattern NEWER_VERSION_PATTERN = Pattern.compile("err:\\s+no update possible: version [0-9]{1,2}\\.[0-9]{2}\\.[0-9]{2}\\.[0-9]{6,} is lower than [0-9]{1,2}\\.[0-9]{2}\\.[0-9]{2}\\.[0-9]{6,}", 2);
    private static final Pattern ERROR_PATTERN = Pattern.compile("(^err:)|(wrong usage!)|(permission denied)|(installation failed)", 2);
    private static final Pattern LOG_FILE_PATTERN = Pattern.compile("^Log file written to '(.+)'", 2);
    protected RunReason runReason = RunReason.INSTALL_CLIENT;
    protected HdbInstExecutable hdbInstExecutable = null;
    private Map<HdbInstOption, String> options = new HashMap<HdbInstOption, String>();
    private Map<HdbInstOption, String> optionsForStdin = new HashMap<HdbInstOption, String>();
    private Map<HdbInstOption, InstallationParameter> installationParameters = new HashMap<HdbInstOption, InstallationParameter>();
    private boolean foundErrorInOutput = false;
    private boolean newerVersionFound = false;
    private String hdbInstLogFile = null;
    private OsToolBox os = OsToolboxFactory.getToolbox();
    private List<GenericInstallationParameter> genericOptions = new ArrayList<GenericInstallationParameter>();

    protected HdbInst(HdbInstExecutable hdbInstExecutable) {
        this.hdbInstExecutable = hdbInstExecutable;
    }

    public void addInstallationParameter(InstallationParameter parameter) {
        HdbInstOption option = parameter.getHdbInstOption();
        String value = parameter.getValue();
        switch (option) {
            case PASSWORD: 
            case SYSTEM_USER_PASSWORD: {
                this.optionsForStdin.put(option, value);
                break;
            }
            default: {
                this.options.put(option, value);
            }
        }
        this.installationParameters.put(option, parameter);
    }

    public void addInstallationParameters(List<InstallationParameter> parameters) {
        for (InstallationParameter parameter : parameters) {
            if (parameter instanceof GenericInstallationParameter) {
                this.genericOptions.add((GenericInstallationParameter)parameter);
                continue;
            }
            this.addInstallationParameter(parameter);
        }
    }

    public HdbInstExecutable get() {
        return this.hdbInstExecutable;
    }

    public void installServer() {
        this.runReason = RunReason.INSTALL_SERVER;
        this.foundErrorInOutput = false;
        this.hdbInstLogFile = null;
        String[] commandLine = this.getCommandLineForInstallServer().toArray(new String[0]);
        String[] passwordForStdin = this.getPasswordsForStdin();
        this.execute(commandLine, passwordForStdin);
        if (this.foundErrorInOutput || this.exitValue != 0) {
            this.throwException();
        }
    }

    public void installClient() {
        this.runReason = RunReason.INSTALL_CLIENT;
        this.foundErrorInOutput = false;
        this.newerVersionFound = false;
        this.hdbInstLogFile = null;
        String[] commandLine = this.getCommandLineForInstallClient().toArray(new String[0]);
        this.execute(commandLine);
        if (this.foundErrorInOutput || this.exitValue != 0) {
            if (this.newerVersionFound) {
                this.localLogger("Found newer version of HANA client. Skipping installation.");
            } else {
                this.throwException();
            }
        }
    }

    @Override
    protected void handleStdoutStderr(String message) {
        Matcher logFileMatcher;
        switch (this.runReason) {
            case INSTALL_CLIENT: {
                Matcher matcher = NEWER_VERSION_PATTERN.matcher(message);
                if (!matcher.find()) break;
                this.newerVersionFound = true;
            }
        }
        Matcher errorMatcher = ERROR_PATTERN.matcher(message);
        if (errorMatcher.find()) {
            this.foundErrorInOutput = true;
        }
        if ((logFileMatcher = LOG_FILE_PATTERN.matcher(message)).find()) {
            this.hdbInstLogFile = logFileMatcher.group(1);
        }
    }

    public List<String> getCommandLineForInstallServer() {
        List<HdbInstOption> missingOptions = this.isOptionMissing(HdbInstOption.SID, HdbInstOption.NUMBER, HdbInstOption.HOSTNAME);
        if (this.os.onUnix()) {
            missingOptions.addAll(this.isOptionMissing(HdbInstOption.SAPMNT));
        }
        if (missingOptions.size() > 0) {
            throw new HdbException(missingOptions + " Missing option[s] to install server software!");
        }
        CommandList commands = new CommandList();
        commands.add(this.hdbInstExecutable.get().getAbsolutePath());
        commands.add(HdbInstOption.BATCH.toString());
        commands.add(HdbInstOption.READ_PASSWORD_FROM_STDIN.toString());
        for (Map.Entry<HdbInstOption, String> option : this.options.entrySet()) {
            HdbInstOption key = option.getKey();
            String value = option.getValue();
            commands.add(key, value);
        }
        commands = this.addGenericInstallationParameters(commands);
        return commands;
    }

    private CommandList addGenericInstallationParameters(CommandList commands) {
        for (GenericInstallationParameter parameter : this.genericOptions) {
            HdbInstOption option = parameter.getHdbInstOption();
            String value = parameter.getValue();
            if (commands.contains(option)) {
                LogFactory.writeLogEntry(this.getClass(), (Object)((Object)option) + " Removing option from command list.");
                commands.remove(option);
                if (value.isEmpty()) continue;
                LogFactory.writeLogEntry(this.getClass(), (Object)((Object)option) + " " + value + " Adding additional installation option from environment.");
                commands.add(option, value);
                continue;
            }
            LogFactory.writeLogEntry(this.getClass(), (Object)((Object)option) + " " + value + " Adding additional installation option from environment.");
            commands.add(option, value);
        }
        return commands;
    }

    public List<String> getCommandLineForInstallClient() {
        List<HdbInstOption> missingOptions = this.os.onUnix() ? this.isOptionMissing(HdbInstOption.SID, HdbInstOption.PATH) : this.isOptionMissing(HdbInstOption.PATH);
        if (missingOptions.size() > 0) {
            throw new HdbException(missingOptions + " Missing option[s] to install client software!");
        }
        CommandList commands = new CommandList();
        commands.add(this.hdbInstExecutable.get().getAbsolutePath());
        commands.add(HdbInstOption.BATCH.toString());
        commands.add(HdbInstOption.A, "client");
        for (Map.Entry<HdbInstOption, String> entry : this.options.entrySet()) {
            HdbInstOption key = entry.getKey();
            String value = entry.getValue();
            commands.add(key, value);
        }
        commands = this.addGenericInstallationParameters(commands);
        if (this.os.onWindows()) {
            WinVersion winVersion = new WinVersion();
        }
        return commands;
    }

    private List<HdbInstOption> isOptionMissing(HdbInstOption ... mandatoryOptions) {
        ArrayList<HdbInstOption> missing = new ArrayList<HdbInstOption>();
        for (HdbInstOption mandatoryOption : mandatoryOptions) {
            if (this.options.containsKey((Object)mandatoryOption)) continue;
            missing.add(mandatoryOption);
        }
        return missing;
    }

    public String[] getPasswordsForStdin() {
        String osSidAdmPassword = this.optionsForStdin.get((Object)HdbInstOption.PASSWORD);
        String dbUserSystemPassword = this.optionsForStdin.get((Object)HdbInstOption.SYSTEM_USER_PASSWORD);
        if (osSidAdmPassword == null || dbUserSystemPassword == null) {
            throw new HdbException("The passwords of both the database system user and the <SID>adm user must be set for server installation!");
        }
        return new String[]{osSidAdmPassword, dbUserSystemPassword};
    }

    public InstallationParameter getInstallationOption(HdbInstOption option) {
        return this.installationParameters.get((Object)option);
    }

    private void throwException() {
        ArrayList<String> logFiles = new ArrayList<String>();
        for (File logFile : LogFactory.getLogWriterFiles()) {
            logFiles.add(logFile.getAbsolutePath());
        }
        if (this.hdbInstLogFile != null) {
            logFiles.add(this.hdbInstLogFile);
        }
        throw new HdbException("An error occured during command execution. Please check logfile for further information. Current Logfiles: " + ((Object)logFiles).toString());
    }

    protected void listSystems() {
        String[] commandLine = this.getCommandLineForListSystems().toArray(new String[0]);
        this.execute(commandLine);
    }

    public List<String> getCommandLineForListSystems() {
        CommandList commands = new CommandList();
        commands.add(this.hdbInstExecutable.get().getAbsolutePath());
        commands.add(HdbInstOption.LIST_SYSTEMS.toString());
        return commands;
    }

    public void setOsToolBox(OsToolBox os) {
        this.os = os;
    }

    public static enum RunReason {
        INSTALL_CLIENT,
        INSTALL_SERVER;

    }
}

