/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.utils.HdbInst;
import com.sap.hdb.sl.lib.utils.HdbInstExecutable;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import java.io.File;

public class HdbInstFactory {
    public static HdbInstExecutable getHdbInstExecutable(File hdbInst) {
        return new HdbInstExecutable(hdbInst);
    }

    public static HdbInstExecutable getHdbInstExecutable(String hdbInst) {
        return new HdbInstExecutable(new File(hdbInst));
    }

    public static HdbInst getHdbInst(HdbInstExecutable hdbInstExe) {
        return new HdbInst(hdbInstExe);
    }

    public static HdbInst getHdbInst(File hdbInst) {
        HdbInstExecutable exe = new HdbInstExecutable(hdbInst);
        if (exe.isHdbInst()) {
            return new HdbInst(exe);
        }
        throw new HdbException(exe + " must point to a valid hdbinst executable!");
    }

    public static HdbInst getHdbInst(CmdClazzParameterMap parameters) {
        CmdClazzParameter parameter = parameters.get(CmdClazzParameterName.HDBINSTEXE);
        HdbInstExecutable hdbInstExe = null;
        if (!(parameter instanceof HdbInstExecutable)) {
            throw new HdbException(parameter.getClass() + " Class must be instance of " + HdbInstExecutable.class);
        }
        hdbInstExe = (HdbInstExecutable)parameter;
        return HdbInstFactory.getHdbInst(hdbInstExe);
    }
}

