/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.operating.system.ExternalProcess;
import com.sap.hdb.sl.lib.operating.system.OsToolBox;
import com.sap.hdb.sl.lib.operating.system.OsToolboxFactory;
import com.sap.hdb.sl.lib.utils.CommandList;
import com.sap.hdb.sl.lib.utils.GenericInstallationParameter;
import com.sap.hdb.sl.lib.utils.HdbInstOption;
import com.sap.hdb.sl.lib.utils.HdbLcmExecutable;
import com.sap.hdb.sl.lib.utils.InstallationParameter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HdbLcm
extends ExternalProcess {
    private static final boolean USE_XML = true;
    private static final Pattern ERROR_PATTERN = Pattern.compile("(^err:)|(wrong usage!)|(permission denied)|(installation failed)", 2);
    private static final Pattern LOG_FILE_PATTERN = Pattern.compile("^Log file written to '(.+)'", 2);
    protected RunReason runReason = RunReason.INSTALL_SERVER;
    protected HdbLcmExecutable hdbLcmExecutable = null;
    private Map<HdbInstOption, String> options = new HashMap<HdbInstOption, String>();
    private Map<HdbInstOption, String> optionsForStdin = new HashMap<HdbInstOption, String>();
    private Map<HdbInstOption, InstallationParameter> installationParameters = new HashMap<HdbInstOption, InstallationParameter>();
    private boolean foundErrorInOutput = false;
    private String hdbLcmLogFile = null;
    private OsToolBox os = OsToolboxFactory.getToolbox();
    private List<GenericInstallationParameter> genericOptions = new ArrayList<GenericInstallationParameter>();

    protected HdbLcm(HdbLcmExecutable hdbLcmExecutable) {
        this.hdbLcmExecutable = hdbLcmExecutable;
    }

    public void addInstallationParameter(InstallationParameter parameter) {
        HdbInstOption option = parameter.getHdbInstOption();
        String value = parameter.getValue();
        switch (option) {
            case PASSWORD: 
            case SYSTEM_USER_PASSWORD: 
            case SAPADM_PASSWORD: {
                this.optionsForStdin.put(option, value);
                break;
            }
            default: {
                this.options.put(option, value);
            }
        }
        this.installationParameters.put(option, parameter);
    }

    public void addInstallationParameters(List<InstallationParameter> parameters) {
        for (InstallationParameter parameter : parameters) {
            if (parameter instanceof GenericInstallationParameter) {
                this.genericOptions.add((GenericInstallationParameter)parameter);
                continue;
            }
            this.addInstallationParameter(parameter);
        }
    }

    public HdbLcmExecutable get() {
        return this.hdbLcmExecutable;
    }

    public void installServer() {
        this.runReason = RunReason.INSTALL_SERVER;
        this.foundErrorInOutput = false;
        this.hdbLcmLogFile = null;
        String[] passwordForStdin = null;
        String[] commandLine = this.getCommandLineForInstallServer().toArray(new String[0]);
        passwordForStdin = this.getPasswordsForStdinInXML();
        this.execute(commandLine, passwordForStdin);
        if (this.foundErrorInOutput || this.exitValue != 0) {
            this.throwException();
        }
    }

    public void updateComponent() {
        this.runReason = RunReason.UPDATE_COMPONENTS;
        this.foundErrorInOutput = false;
        this.hdbLcmLogFile = null;
        String[] passwordForStdin = null;
        String[] commandLine = this.getCommandLineForUpdateComponent().toArray(new String[0]);
        passwordForStdin = this.getPasswordsForStdinInXML();
        this.execute(commandLine, passwordForStdin);
        if (this.foundErrorInOutput || this.exitValue != 0) {
            this.throwException();
        }
    }

    @Override
    protected void handleStdoutStderr(String message) {
        Matcher logFileMatcher;
        switch (this.runReason) {
            default: 
        }
        Matcher errorMatcher = ERROR_PATTERN.matcher(message);
        if (errorMatcher.find()) {
            this.foundErrorInOutput = true;
        }
        if ((logFileMatcher = LOG_FILE_PATTERN.matcher(message)).find()) {
            this.hdbLcmLogFile = logFileMatcher.group(1);
        }
    }

    public List<String> getCommandLineForInstallServer() {
        List<HdbInstOption> missingOptions = this.isOptionMissing(HdbInstOption.SID, HdbInstOption.NUMBER, HdbInstOption.HOSTNAME);
        if (this.os.onUnix()) {
            missingOptions.addAll(this.isOptionMissing(HdbInstOption.COMPONENTS));
        }
        if (missingOptions.size() > 0) {
            throw new HdbException(missingOptions + " Missing option[s] to install server software!");
        }
        CommandList commands = new CommandList();
        commands.add(this.hdbLcmExecutable.get().getAbsolutePath());
        commands.add(HdbInstOption.ACTION, "install");
        commands.add(HdbInstOption.BATCH.toString());
        commands.add(HdbInstOption.READ_PASSWORD_FROM_STDIN, "xml");
        for (Map.Entry<HdbInstOption, String> option : this.options.entrySet()) {
            HdbInstOption key = option.getKey();
            String value = option.getValue();
            commands.add(key, value);
        }
        commands = this.addGenericInstallationParameters(commands);
        return commands;
    }

    public List<String> getCommandLineForUpdateComponent() {
        List<HdbInstOption> missingOptions = this.isOptionMissing(HdbInstOption.COMPONENTS);
        if (missingOptions.size() > 0) {
            throw new HdbException(missingOptions + " Missing option[s] to install server software!");
        }
        CommandList commands = new CommandList();
        commands.add(this.hdbLcmExecutable.get().getAbsolutePath());
        commands.add(HdbInstOption.ACTION, "update_components");
        commands.add(HdbInstOption.BATCH.toString());
        commands.add(HdbInstOption.READ_PASSWORD_FROM_STDIN, "xml");
        for (Map.Entry<HdbInstOption, String> option : this.options.entrySet()) {
            HdbInstOption key = option.getKey();
            String value = option.getValue();
            commands.add(key, value);
        }
        commands = this.addGenericInstallationParameters(commands);
        return commands;
    }

    private CommandList addGenericInstallationParameters(CommandList commands) {
        for (GenericInstallationParameter parameter : this.genericOptions) {
            HdbInstOption option = parameter.getHdbInstOption();
            String value = parameter.getValue();
            if (commands.contains(option)) {
                LogFactory.writeLogEntry(this.getClass(), (Object)((Object)option) + " Removing option from command list.");
                commands.remove(option);
                if (value.isEmpty()) continue;
                LogFactory.writeLogEntry(this.getClass(), (Object)((Object)option) + " " + value + " Adding additional installation option from environment.");
                commands.add(option, value);
                continue;
            }
            LogFactory.writeLogEntry(this.getClass(), (Object)((Object)option) + " " + value + " Adding additional installation option from environment.");
            commands.add(option, value);
        }
        return commands;
    }

    private List<HdbInstOption> isOptionMissing(HdbInstOption ... mandatoryOptions) {
        ArrayList<HdbInstOption> missing = new ArrayList<HdbInstOption>();
        for (HdbInstOption mandatoryOption : mandatoryOptions) {
            if (this.options.containsKey((Object)mandatoryOption)) continue;
            missing.add(mandatoryOption);
        }
        return missing;
    }

    public String[] getPasswordsForStdin() {
        String osSidAdmPassword = this.optionsForStdin.get((Object)HdbInstOption.PASSWORD);
        String dbUserSystemPassword = this.optionsForStdin.get((Object)HdbInstOption.SYSTEM_USER_PASSWORD);
        String sapadmUserPassword = this.optionsForStdin.get((Object)HdbInstOption.SAPADM_PASSWORD);
        if (osSidAdmPassword == null || dbUserSystemPassword == null || sapadmUserPassword == null) {
            throw new HdbException("The passwords of the database system user, the <SID>adm user and the SAP Host Agent User must be set for server installation!");
        }
        return new String[]{osSidAdmPassword, dbUserSystemPassword, sapadmUserPassword};
    }

    public String[] getPasswordsForStdinInXML() {
        String osSidAdmPassword = this.optionsForStdin.get((Object)HdbInstOption.PASSWORD);
        String dbUserSystemPassword = this.optionsForStdin.get((Object)HdbInstOption.SYSTEM_USER_PASSWORD);
        String sapadmUserPassword = this.optionsForStdin.get((Object)HdbInstOption.SAPADM_PASSWORD);
        if (this.runReason.equals((Object)RunReason.UPDATE_COMPONENTS)) {
            if (dbUserSystemPassword == null) {
                throw new HdbException("The passwords of the database system user must be set to update component!");
            }
        } else if (this.runReason.equals((Object)RunReason.INSTALL_SERVER) && (osSidAdmPassword == null || dbUserSystemPassword == null || sapadmUserPassword == null)) {
            throw new HdbException("The passwords of the database system user, the <SID>adm user and the SAP Host Agent User must be set for server installation!");
        }
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Passwords><password><![CDATA[" + osSidAdmPassword + "]]></password>" + "<sapadm_password><![CDATA[" + sapadmUserPassword + "]]></sapadm_password>" + "<system_user_password><![CDATA[" + dbUserSystemPassword + "]]></system_user_password>" + "</Passwords>";
        return new String[]{xml};
    }

    public InstallationParameter getInstallationOption(HdbInstOption option) {
        return this.installationParameters.get((Object)option);
    }

    private void throwException() {
        ArrayList<String> logFiles = new ArrayList<String>();
        for (File logFile : LogFactory.getLogWriterFiles()) {
            logFiles.add(logFile.getAbsolutePath());
        }
        if (this.hdbLcmLogFile != null) {
            logFiles.add(this.hdbLcmLogFile);
        }
        throw new HdbException("An error occured during command execution. Please check logfile for further information. Current Logfiles: " + ((Object)logFiles).toString());
    }

    public void setOsToolBox(OsToolBox os) {
        this.os = os;
    }

    public static enum RunReason {
        INSTALL_SERVER,
        UPDATE_COMPONENTS;

    }
}

