/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.utils.HdbLcm;
import com.sap.hdb.sl.lib.utils.HdbLcmExecutable;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import java.io.File;

public class HdbLcmFactory {
    public static HdbLcmExecutable getHdbLcmExecutable(File hdbLcm) {
        return new HdbLcmExecutable(hdbLcm);
    }

    public static HdbLcmExecutable getHdbLcmExecutable(String hdbLcm) {
        return new HdbLcmExecutable(new File(hdbLcm));
    }

    public static HdbLcm getHdbLcm(HdbLcmExecutable hdbLcmExe) {
        return new HdbLcm(hdbLcmExe);
    }

    public static HdbLcm getHdbLcm(File hdbLcm) {
        HdbLcmExecutable exe = new HdbLcmExecutable(hdbLcm);
        if (exe.isHdbLcm()) {
            return new HdbLcm(exe);
        }
        throw new HdbException(exe + " must point to a valid hdblcm executable!");
    }

    public static HdbLcm getHdbLcm(CmdClazzParameterMap parameters) {
        CmdClazzParameter parameter = parameters.get(CmdClazzParameterName.HDBLCMEXE);
        HdbLcmExecutable hdbLcmExe = null;
        if (!(parameter instanceof HdbLcmExecutable)) {
            throw new HdbException(parameter.getClass() + " Class must be instance of " + HdbLcmExecutable.class);
        }
        hdbLcmExe = (HdbLcmExecutable)parameter;
        return HdbLcmFactory.getHdbLcm(hdbLcmExe);
    }
}

